/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.awt;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.media.nativewindow.WindowClosingProtocol;
import jogamp.nativewindow.awt.AWTMisc;

public class AWTWindowClosingProtocol
implements WindowClosingProtocol {
    private Component comp;
    private Runnable closingOperation;
    private volatile boolean closingListenerSet = false;
    private Object closingListenerLock = new Object();
    private WindowClosingProtocol.WindowClosingMode defaultCloseOperation = WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE;
    private boolean defaultCloseOperationSetByUser = false;
    WindowListener windowClosingAdapter = new WindowClosingAdapter();

    public AWTWindowClosingProtocol(Component component, Runnable runnable) {
        this.comp = component;
        this.closingOperation = runnable;
    }

    final boolean addClosingListenerImpl() {
        Window window = AWTMisc.getWindow(this.comp);
        if (null != window) {
            window.addWindowListener(this.windowClosingAdapter);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addClosingListenerOneShot() {
        if (!this.closingListenerSet) {
            Object object = this.closingListenerLock;
            synchronized (object) {
                if (!this.closingListenerSet) {
                    this.closingListenerSet = this.addClosingListenerImpl();
                    return this.closingListenerSet;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeClosingListener() {
        if (this.closingListenerSet) {
            Object object = this.closingListenerLock;
            synchronized (object) {
                Window window;
                if (this.closingListenerSet && null != (window = AWTMisc.getWindow(this.comp))) {
                    window.removeWindowListener(this.windowClosingAdapter);
                    this.closingListenerSet = false;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final WindowClosingProtocol.WindowClosingMode getDefaultCloseOperation() {
        Object object = this.closingListenerLock;
        synchronized (object) {
            if (this.defaultCloseOperationSetByUser) {
                return this.defaultCloseOperation;
            }
        }
        return AWTMisc.getNWClosingOperation(this.comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final WindowClosingProtocol.WindowClosingMode setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode windowClosingMode) {
        Object object = this.closingListenerLock;
        synchronized (object) {
            WindowClosingProtocol.WindowClosingMode windowClosingMode2 = this.defaultCloseOperation;
            this.defaultCloseOperation = windowClosingMode;
            this.defaultCloseOperationSetByUser = true;
            return windowClosingMode2;
        }
    }

    class WindowClosingAdapter
    extends WindowAdapter {
        WindowClosingAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            WindowClosingProtocol.WindowClosingMode windowClosingMode = AWTWindowClosingProtocol.this.getDefaultCloseOperation();
            if (WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE == windowClosingMode) {
                AWTWindowClosingProtocol.this.closingOperation.run();
            }
        }
    }
}

