/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh.jsch;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.providers.ssh.ScpHelper;
import org.apache.maven.wagon.providers.ssh.jsch.AbstractJschWagon;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;

public class ScpWagon
extends AbstractJschWagon {
    private static final char COPY_START_CHAR = 'C';
    private static final char ACK_SEPARATOR = ' ';
    private static final String END_OF_FILES_MSG = "E\n";
    private static final int LINE_BUFFER_SIZE = 8192;
    private static final byte LF = 10;
    private ChannelExec channel;
    private InputStream channelInputStream;
    private OutputStream channelOutputStream;

    private void setFileGroup(RepositoryPermissions permissions, String basedir, Resource resource) throws CommandExecutionException {
        if (permissions != null && permissions.getGroup() != null) {
            this.executeCommand("chgrp -f " + permissions.getGroup() + " " + ScpWagon.getPath((String)basedir, (String)resource.getName()));
        }
    }

    protected void cleanupPutTransfer(Resource resource) {
        if (this.channel != null) {
            this.channel.disconnect();
            this.channel = null;
        }
    }

    protected void finishPutTransfer(Resource resource, InputStream input, OutputStream output) throws TransferFailedException {
        try {
            ScpWagon.sendEom(output);
            this.checkAck(this.channelInputStream);
            output.write(END_OF_FILES_MSG.getBytes());
            output.flush();
        }
        catch (IOException e) {
            this.handleIOException(resource, e);
        }
        String basedir = this.getRepository().getBasedir();
        try {
            this.setFileGroup(this.getRepository().getPermissions(), basedir, resource);
        }
        catch (CommandExecutionException e) {
            this.fireTransferError(resource, (Exception)((Object)e), 6);
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkAck(InputStream in) throws IOException {
        int code = in.read();
        if (code == -1) {
            throw new IOException("Unexpected end of data");
        }
        if (code == 1) {
            String line = this.readLine(in);
            throw new IOException("SCP terminated with error: '" + line + "'");
        }
        if (code == 2) {
            throw new IOException("SCP terminated with error (code: " + code + ")");
        }
        if (code != 0) {
            throw new IOException("SCP terminated with unknown error code");
        }
    }

    protected void finishGetTransfer(Resource resource, InputStream input, OutputStream output) throws TransferFailedException {
        try {
            this.checkAck(input);
            ScpWagon.sendEom(this.channelOutputStream);
        }
        catch (IOException e) {
            this.handleGetException(resource, e);
        }
    }

    protected void cleanupGetTransfer(Resource resource) {
        if (this.channel != null) {
            this.channel.disconnect();
        }
    }

    protected void getTransfer(Resource resource, OutputStream output, InputStream input, boolean closeInput, int maxSize) throws TransferFailedException {
        super.getTransfer(resource, output, input, closeInput, (int)resource.getContentLength());
    }

    protected String readLine(InputStream in) throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            if (sb.length() > 8192) {
                throw new IOException("Remote server sent a too long line");
            }
            int c = in.read();
            if (c < 0) {
                throw new IOException("Remote connection terminated unexpectedly.");
            }
            if (c == 10) break;
            sb.append((char)c);
        }
        return sb.toString();
    }

    protected static void sendEom(OutputStream out) throws IOException {
        out.write(0);
        out.flush();
    }

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException {
        Resource resource = inputData.getResource();
        String path = ScpWagon.getPath((String)this.getRepository().getBasedir(), (String)resource.getName());
        String cmd = "scp -p -f " + path;
        this.fireTransferDebug("Executing command: " + cmd);
        try {
            String line;
            this.channel = (ChannelExec)this.session.openChannel("exec");
            this.channel.setCommand(cmd);
            this.channelOutputStream = this.channel.getOutputStream();
            InputStream in = this.channel.getInputStream();
            inputData.setInputStream(in);
            this.channel.connect();
            ScpWagon.sendEom(this.channelOutputStream);
            int exitCode = in.read();
            if (exitCode == 84) {
                line = this.readLine(in);
                String[] times = line.split(" ");
                resource.setLastModified(Long.valueOf(times[0]) * 1000L);
                ScpWagon.sendEom(this.channelOutputStream);
                exitCode = in.read();
            }
            line = this.readLine(in);
            if (exitCode != 67) {
                if (exitCode == 1 && line.indexOf("No such file or directory") != -1) {
                    throw new ResourceDoesNotExistException(line);
                }
                throw new IOException("Exit code: " + exitCode + " - " + line);
            }
            if (line == null) {
                throw new EOFException("Unexpected end of data");
            }
            String perms = line.substring(0, 4);
            this.fireTransferDebug("Remote file permissions: " + perms);
            if (line.charAt(4) != ' ' && line.charAt(5) != ' ') {
                throw new IOException("Invalid transfer header: " + line);
            }
            int index = line.indexOf(32, 5);
            if (index < 0) {
                throw new IOException("Invalid transfer header: " + line);
            }
            int filesize = Integer.valueOf(line.substring(5, index));
            this.fireTransferDebug("Remote file size: " + filesize);
            resource.setContentLength((long)filesize);
            String filename = line.substring(index + 1);
            this.fireTransferDebug("Remote filename: " + filename);
            ScpWagon.sendEom(this.channelOutputStream);
        }
        catch (JSchException e) {
            this.handleGetException(resource, (Exception)((Object)e));
        }
        catch (IOException e) {
            this.handleGetException(resource, e);
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        Resource resource = outputData.getResource();
        String basedir = this.getRepository().getBasedir();
        String path = ScpWagon.getPath((String)basedir, (String)resource.getName());
        String dir = ScpHelper.getResourceDirectory((String)resource.getName());
        try {
            this.sshTool.createRemoteDirectories(ScpWagon.getPath((String)basedir, (String)dir), this.getRepository().getPermissions());
        }
        catch (CommandExecutionException e) {
            this.fireTransferError(resource, (Exception)((Object)e), 6);
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        String octalMode = this.getOctalMode(this.getRepository().getPermissions());
        String command = "scp";
        if (octalMode != null) {
            command = command + " -p";
        }
        command = command + " -t \"" + path + "\"";
        this.fireTransferDebug("Executing command: " + command);
        String resourceName = resource.getName();
        OutputStream out = null;
        try {
            this.channel = (ChannelExec)this.session.openChannel("exec");
            this.channel.setCommand(command);
            out = this.channel.getOutputStream();
            outputData.setOutputStream(out);
            this.channelInputStream = this.channel.getInputStream();
            this.channel.connect();
            this.checkAck(this.channelInputStream);
            long filesize = resource.getContentLength();
            String mode = octalMode == null ? "0644" : octalMode;
            command = "C" + mode + " " + filesize + " ";
            command = resourceName.lastIndexOf(47) > 0 ? command + resourceName.substring(resourceName.lastIndexOf(47) + 1) : command + resourceName;
            command = command + "\n";
            out.write(command.getBytes());
            out.flush();
            this.checkAck(this.channelInputStream);
        }
        catch (JSchException e) {
            this.fireTransferError(resource, (Exception)((Object)e), 6);
            String msg = "Error occured while deploying '" + resourceName + "' to remote repository: " + this.getRepository().getUrl() + ": " + e.getMessage();
            throw new TransferFailedException(msg, (Throwable)e);
        }
        catch (IOException e) {
            this.handleIOException(resource, e);
        }
    }

    private void handleIOException(Resource resource, IOException e) throws TransferFailedException {
        if (e.getMessage().indexOf("set mode: Operation not permitted") < 0) {
            this.fireTransferError(resource, e, 6);
            String msg = "Error occured while deploying '" + resource.getName() + "' to remote repository: " + this.getRepository().getUrl() + ": " + e.getMessage();
            throw new TransferFailedException(msg, (Throwable)e);
        }
        this.fireTransferDebug(e.getMessage());
    }

    public String getOctalMode(RepositoryPermissions permissions) {
        String mode = null;
        if (permissions != null && permissions.getFileMode() != null) {
            if (permissions.getFileMode().matches("[0-9]{3,4}")) {
                mode = permissions.getFileMode();
                if (mode.length() == 3) {
                    mode = "0" + mode;
                }
            } else {
                this.fireSessionDebug("Not using non-octal permissions: " + permissions.getFileMode());
            }
        }
        return mode;
    }
}

