/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;

public abstract class TestConsoleOutputRunListener
implements RunListener,
ConsoleOutputReceiver {
    private final ReporterFactory reporterFactory;

    protected TestConsoleOutputRunListener(ReporterFactory reporterFactory) {
        this.reporterFactory = reporterFactory;
    }

    public static TestConsoleOutputRunListener createInstance(ReporterFactory reporterFactory, boolean oneThreadPerClass) {
        return oneThreadPerClass ? new OneThreadPerClassConsoleOutputRunListener(reporterFactory) : new UnknownThreadPerClassConsoleOutputRunListener(reporterFactory);
    }

    protected abstract RunListener getTestSetRunListener(ReportEntry var1);

    protected abstract void clearTestSetRunListener(ReportEntry var1);

    protected abstract RunListener getTestMethodRunListener(ReportEntry var1);

    protected abstract void clearTestMethodRunListener(ReportEntry var1);

    protected abstract ConsoleOutputReceiver getConsoleOutputReceiver();

    protected ReporterFactory getReporterFactory() {
        return this.reporterFactory;
    }

    public void writeTestOutput(byte[] buf, int off, int len, boolean stdout) {
        this.getConsoleOutputReceiver().writeTestOutput(buf, off, len, stdout);
    }

    public void testSetStarting(ReportEntry report) throws ReporterException {
        this.getTestSetRunListener(report).testSetStarting(report);
    }

    public void testSetCompleted(ReportEntry report) throws ReporterException {
        this.getTestSetRunListener(report).testSetCompleted(report);
        this.clearTestSetRunListener(report);
    }

    public void testStarting(ReportEntry report) {
        this.getTestMethodRunListener(report).testStarting(report);
    }

    public void testSucceeded(ReportEntry report) {
        this.getTestMethodRunListener(report).testSucceeded(report);
        this.clearTestMethodRunListener(report);
    }

    public void testAssumptionFailure(ReportEntry report) {
        this.getTestMethodRunListener(report).testAssumptionFailure(report);
        this.clearTestMethodRunListener(report);
    }

    public void testError(ReportEntry report) {
        this.getTestMethodRunListener(report).testError(report);
        this.clearTestMethodRunListener(report);
    }

    public void testFailed(ReportEntry report) {
        this.getTestMethodRunListener(report).testFailed(report);
        this.clearTestMethodRunListener(report);
    }

    public void testSkipped(ReportEntry report) {
        this.getTestMethodRunListener(report).testSkipped(report);
        this.clearTestMethodRunListener(report);
    }

    public static class UnknownThreadPerClassConsoleOutputRunListener
    extends TestConsoleOutputRunListener {
        private final ThreadLocal currentTestMethodListener = new InheritableThreadLocal();
        private final ThreadLocal currentTestSetListener = new InheritableThreadLocal();
        private final Map testSetToRunListener = Collections.synchronizedMap(new HashMap());

        public UnknownThreadPerClassConsoleOutputRunListener(ReporterFactory reporterFactory) {
            super(reporterFactory);
        }

        protected RunListener getTestSetRunListener(ReportEntry reportEntry) {
            RunListener result = (RunListener)this.testSetToRunListener.get(reportEntry.getSourceName());
            if (result == null) {
                result = this.getReporterFactory().createReporter();
                this.testSetToRunListener.put(reportEntry.getSourceName(), result);
            }
            this.currentTestSetListener.set(result);
            return result;
        }

        protected void clearTestSetRunListener(ReportEntry reportEntry) {
            this.currentTestSetListener.remove();
        }

        protected RunListener getTestMethodRunListener(ReportEntry report) {
            RunListener runListener = (RunListener)this.testSetToRunListener.get(report.getSourceName());
            if (runListener == null) {
                runListener = this.getReporterFactory().createReporter();
                this.testSetToRunListener.put(report.getSourceName(), runListener);
            }
            this.currentTestMethodListener.set(runListener);
            return runListener;
        }

        protected void clearTestMethodRunListener(ReportEntry reportEntry) {
            this.currentTestMethodListener.remove();
        }

        protected ConsoleOutputReceiver getConsoleOutputReceiver() {
            ConsoleOutputReceiver consoleOutputReceiver = (ConsoleOutputReceiver)this.currentTestMethodListener.get();
            if (consoleOutputReceiver == null) {
                consoleOutputReceiver = (ConsoleOutputReceiver)this.currentTestSetListener.get();
            }
            return consoleOutputReceiver;
        }
    }

    public static class OneThreadPerClassConsoleOutputRunListener
    extends TestConsoleOutputRunListener {
        private final ThreadLocal currentTestMethodListener = new InheritableThreadLocal();

        public OneThreadPerClassConsoleOutputRunListener(ReporterFactory reporterFactory) {
            super(reporterFactory);
        }

        protected RunListener getTestSetRunListener(ReportEntry reportEntry) {
            return this.getTestMethodRunListener(reportEntry);
        }

        protected void clearTestSetRunListener(ReportEntry reportEntry) {
            this.currentTestMethodListener.remove();
        }

        protected void clearTestMethodRunListener(ReportEntry reportEntry) {
        }

        protected RunListener getTestMethodRunListener(ReportEntry report) {
            RunListener runListener = (RunListener)this.currentTestMethodListener.get();
            if (runListener == null) {
                runListener = this.getReporterFactory().createReporter();
                this.currentTestMethodListener.set(runListener);
            }
            return runListener;
        }

        protected ConsoleOutputReceiver getConsoleOutputReceiver() {
            return (ConsoleOutputReceiver)this.currentTestMethodListener.get();
        }
    }
}

