/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import com.jogamp.common.nio.Buffers;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.MutableSurface;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowException;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.windows.GDI;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.windows.wgl.WGLExt;
import jogamp.opengl.windows.wgl.WGLGLCapabilities;
import jogamp.opengl.windows.wgl.WindowsPbufferWGLContext;
import jogamp.opengl.windows.wgl.WindowsWGLContext;
import jogamp.opengl.windows.wgl.WindowsWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsWGLDrawableFactory;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfiguration;

public class WindowsPbufferWGLDrawable
extends WindowsWGLDrawable {
    private WGLExt cachedWGLExt;
    private long buffer;
    private int floatMode;

    protected WindowsPbufferWGLDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
        super(gLDrawableFactory, nativeSurface, false);
    }

    @Override
    protected void setRealizedImpl() {
        if (this.realized) {
            this.createPbuffer();
        } else {
            this.destroyPbuffer();
        }
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return new WindowsPbufferWGLContext(this, gLContext);
    }

    protected void destroyPbuffer() {
        NativeSurface nativeSurface = this.getNativeSurface();
        if (0L != this.buffer) {
            WGLExt wGLExt = this.cachedWGLExt;
            if (nativeSurface.getSurfaceHandle() != 0L) {
                if (wGLExt.wglReleasePbufferDCARB(this.buffer, nativeSurface.getSurfaceHandle()) == 0) {
                    throw new GLException("Error releasing pbuffer device context: error code " + GDI.GetLastError());
                }
                ((MutableSurface)nativeSurface).setSurfaceHandle(0L);
            }
            if (!wGLExt.wglDestroyPbufferARB(this.buffer)) {
                throw new GLException("Error destroying pbuffer: error code " + GDI.GetLastError());
            }
            this.buffer = 0L;
        }
    }

    public long getPbufferHandle() {
        return this.buffer;
    }

    public int getFloatingPointMode() {
        return this.floatMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPbuffer() {
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)this.getNativeSurface().getGraphicsConfiguration();
        WindowsWGLDrawableFactory.SharedResource sharedResource = ((WindowsWGLDrawableFactory)this.factory).getOrCreateSharedResource(windowsWGLGraphicsConfiguration.getScreen().getDevice());
        NativeSurface nativeSurface = sharedResource.getDrawable().getNativeSurface();
        if (1 >= nativeSurface.lockSurface()) {
            throw new NativeWindowException("Could not lock (sharedSurface): " + this);
        }
        try {
            int n;
            int n2;
            IntBuffer intBuffer;
            long l = nativeSurface.getSurfaceHandle();
            WGLExt wGLExt = ((WindowsWGLContext)sharedResource.getContext()).getWGLExt();
            if (DEBUG) {
                System.out.println("Pbuffer config: " + windowsWGLGraphicsConfiguration);
            }
            int n3 = GLGraphicsConfigurationUtil.getExclusiveWinAttributeBits(false, false, true, false);
            IntBuffer intBuffer2 = Buffers.newDirectIntBuffer((int)512);
            FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer((int)1);
            int[] nArray = new int[1];
            int n4 = 0;
            GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)windowsWGLGraphicsConfiguration.getChosenCapabilities();
            GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
            AbstractGraphicsDevice abstractGraphicsDevice = windowsWGLGraphicsConfiguration.getScreen().getDevice();
            if (DEBUG) {
                System.out.println("Pbuffer parentHdc = " + WindowsPbufferWGLDrawable.toHexString(l));
                System.out.println("Pbuffer chosenCaps: " + gLCapabilitiesImmutable);
            }
            if (!WindowsWGLGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable, intBuffer2, sharedResource, -1, nArray)) {
                throw new GLException("Pbuffer-related extensions not supported");
            }
            this.floatMode = nArray[0];
            boolean bl = gLCapabilitiesImmutable.getPbufferRenderToTexture();
            boolean bl2 = gLCapabilitiesImmutable.getPbufferRenderToTextureRectangle();
            boolean bl3 = gLCapabilitiesImmutable.getPbufferFloatingPointBuffers();
            IntBuffer intBuffer3 = Buffers.newDirectIntBuffer((int)256);
            if (!wGLExt.wglChoosePixelFormatARB(l, intBuffer2, floatBuffer, 256, intBuffer3, intBuffer = Buffers.newDirectIntBuffer((int)1))) {
                throw new GLException("pbuffer creation error: wglChoosePixelFormat() failed");
            }
            int n5 = intBuffer.get(0);
            if (n5 <= 0) {
                throw new GLException("pbuffer creation error: Couldn't find a suitable pixel format");
            }
            if (DEBUG) {
                System.err.println("" + n5 + " suitable pixel formats found");
                for (n2 = 0; n2 < n5; ++n2) {
                    WGLGLCapabilities wGLGLCapabilities = WindowsWGLGraphicsConfiguration.wglARBPFID2GLCapabilities(sharedResource, abstractGraphicsDevice, gLProfile, l, intBuffer3.get(n2), n3);
                    System.err.println("pixel format " + intBuffer3.get(n2) + " (index " + n2 + "): " + wGLGLCapabilities);
                }
            }
            n2 = 0;
            long l2 = 0L;
            for (n = 0; n < n5; ++n) {
                int n6 = intBuffer3.get(n);
                n4 = 0;
                if (bl) {
                    intBuffer2.put(n4++, 8306);
                    if (bl3) {
                        intBuffer2.put(n4++, 8375);
                    } else {
                        intBuffer2.put(n4++, 8310);
                    }
                    intBuffer2.put(n4++, 8307);
                    intBuffer2.put(n4++, bl2 ? 8354 : 8314);
                    intBuffer2.put(n4++, 8308);
                    intBuffer2.put(n4++, 0);
                    intBuffer2.put(n4++, 8243);
                    intBuffer2.put(n4++, 0);
                }
                intBuffer2.put(n4++, 0);
                l2 = wGLExt.wglCreatePbufferARB(l, n6, this.getWidth(), this.getHeight(), intBuffer2);
                if (l2 != 0L) break;
            }
            if (0L == l2) {
                throw new GLException("pbuffer creation error: wglCreatePbuffer() failed: tried " + n5 + " pixel formats, last error was: " + WindowsPbufferWGLDrawable.wglGetLastError());
            }
            n2 = intBuffer3.get(n);
            long l3 = wGLExt.wglGetPbufferDCARB(l2);
            if (l3 == 0L) {
                throw new GLException("pbuffer creation error: wglGetPbufferDC() failed");
            }
            NativeSurface nativeSurface2 = this.getNativeSurface();
            this.buffer = l2;
            ((MutableSurface)nativeSurface2).setSurfaceHandle(l3);
            this.cachedWGLExt = wGLExt;
            WGLGLCapabilities wGLGLCapabilities = WindowsWGLGraphicsConfiguration.wglARBPFID2GLCapabilities(sharedResource, abstractGraphicsDevice, gLProfile, l, n2, n3);
            if (null == wGLGLCapabilities) {
                throw new GLException("pbuffer creation error: unable to re-query chosen PFD ID: " + n2 + ", hdc " + GLDrawableImpl.toHexString(l3));
            }
            if (wGLGLCapabilities.isOnscreen() || !wGLGLCapabilities.isPBuffer()) {
                throw new GLException("Error: Selected Onscreen Caps for PBuffer: " + wGLGLCapabilities);
            }
            windowsWGLGraphicsConfiguration.setCapsPFD(wGLGLCapabilities);
        }
        finally {
            nativeSurface.unlockSurface();
        }
    }

    private static String wglGetLastError() {
        return WindowsWGLDrawableFactory.wglGetLastError();
    }
}

