/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.swt;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.swt.SWTAccessor;
import com.jogamp.opengl.JoglVersion;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.ProxySurface;
import javax.media.nativewindow.UpstreamSurfaceHook;
import javax.media.opengl.GL;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLRunnable;
import javax.media.opengl.Threading;
import jogamp.opengl.Debug;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableHelper;
import jogamp.opengl.GLDrawableImpl;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class GLCanvas
extends Canvas
implements GLAutoDrawable {
    private static final boolean DEBUG = Debug.debug("GLCanvas");
    private final RecursiveLock lock = LockFactory.createRecursiveLock();
    private final GLDrawableHelper helper = new GLDrawableHelper();
    private final GLContext shareWith;
    private final GLCapabilitiesImmutable capsRequested;
    private final GLCapabilitiesChooser capsChooser;
    private volatile GLDrawableImpl drawable;
    private GLContextImpl context;
    private AbstractGraphicsDevice device;
    private int additionalCtxCreationFlags = 0;
    private volatile boolean sendReshape;
    private final Runnable initAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.helper.init(GLCanvas.this, !GLCanvas.this.sendReshape);
        }
    };
    private final Runnable displayAction = new Runnable(){

        @Override
        public void run() {
            if (GLCanvas.this.sendReshape) {
                GLCanvas.this.helper.reshape(GLCanvas.this, 0, 0, GLCanvas.this.getWidth(), GLCanvas.this.getHeight());
                GLCanvas.this.sendReshape = false;
            }
            GLCanvas.this.helper.display(GLCanvas.this);
        }
    };
    private final Runnable makeCurrentAndDisplayOnEDTAction = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RecursiveLock recursiveLock = GLCanvas.this.lock;
            recursiveLock.lock();
            try {
                GLCanvas.this.helper.invokeGL(GLCanvas.this.drawable, GLCanvas.this.context, GLCanvas.this.displayAction, GLCanvas.this.initAction);
            }
            finally {
                recursiveLock.unlock();
            }
        }
    };
    private final Runnable swapBuffersOnEDTAction = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RecursiveLock recursiveLock = GLCanvas.this.lock;
            recursiveLock.lock();
            try {
                if (null != GLCanvas.this.drawable) {
                    GLCanvas.this.drawable.swapBuffers();
                }
            }
            finally {
                recursiveLock.unlock();
            }
        }
    };
    private final Runnable postDisposeGLAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.context = null;
            if (null != GLCanvas.this.drawable) {
                GLCanvas.this.drawable.setRealized(false);
                GLCanvas.this.drawable = null;
            }
        }
    };
    private final Runnable disposeOnEDTGLAction = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RecursiveLock recursiveLock = GLCanvas.this.lock;
            recursiveLock.lock();
            try {
                if (null != GLCanvas.this.drawable && null != GLCanvas.this.context) {
                    boolean bl = false;
                    GLAnimatorControl gLAnimatorControl = GLCanvas.this.getAnimator();
                    if (null != gLAnimatorControl) {
                        bl = gLAnimatorControl.pause();
                    }
                    if (GLCanvas.this.context.isCreated()) {
                        GLCanvas.this.helper.disposeGL(GLCanvas.this, GLCanvas.this.drawable, GLCanvas.this.context, GLCanvas.this.postDisposeGLAction);
                    }
                    if (bl) {
                        gLAnimatorControl.resume();
                    }
                }
                if (null != GLCanvas.this.device) {
                    GLCanvas.this.device.close();
                    GLCanvas.this.device = null;
                }
                SWTAccessor.setRealized((Control)GLCanvas.this, false);
            }
            finally {
                recursiveLock.unlock();
            }
        }
    };
    private volatile Rectangle clientArea;
    private final UpstreamSurfaceHook swtCanvasUpStreamHook = new UpstreamSurfaceHook(){

        @Override
        public final void create(ProxySurface proxySurface) {
        }

        @Override
        public final void destroy(ProxySurface proxySurface) {
        }

        @Override
        public final int getWidth(ProxySurface proxySurface) {
            return ((GLCanvas)GLCanvas.this).clientArea.width;
        }

        @Override
        public final int getHeight(ProxySurface proxySurface) {
            return ((GLCanvas)GLCanvas.this).clientArea.height;
        }

        public String toString() {
            return "SWTCanvasUpstreamSurfaceHook[upstream: " + GLCanvas.this.toString() + ", " + ((GLCanvas)GLCanvas.this).clientArea.width + "x" + ((GLCanvas)GLCanvas.this).clientArea.height + "]";
        }
    };

    public static GLCanvas create(final Composite composite, final int n, final GLCapabilitiesImmutable gLCapabilitiesImmutable, final GLCapabilitiesChooser gLCapabilitiesChooser, final GLContext gLContext) {
        final GLCanvas[] gLCanvasArray = new GLCanvas[]{null};
        composite.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                gLCanvasArray[0] = new GLCanvas(composite, n, gLCapabilitiesImmutable, gLCapabilitiesChooser, gLContext);
            }
        });
        return gLCanvasArray[0];
    }

    public GLCanvas(Composite composite, int n, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext) {
        super(composite, n | 0x40000);
        GLProfile.initSingleton();
        SWTAccessor.setRealized((Control)this, true);
        this.clientArea = this.getClientArea();
        this.device = SWTAccessor.getDevice((Control)this);
        if (null == gLCapabilitiesImmutable) {
            gLCapabilitiesImmutable = new GLCapabilities(GLProfile.getDefault(this.device));
        }
        this.capsRequested = gLCapabilitiesImmutable;
        this.capsChooser = gLCapabilitiesChooser;
        this.shareWith = gLContext;
        this.drawable = null;
        this.context = null;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (!GLCanvas.this.helper.isExternalAnimatorAnimating()) {
                    GLCanvas.this.display();
                }
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                GLCanvas.this.updateSizeCheck();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateSizeCheck() {
        Rectangle rectangle = this.clientArea;
        Rectangle rectangle2 = this.getClientArea();
        if (rectangle2 != null && (rectangle2.width != rectangle.width || rectangle2.height != rectangle.height)) {
            this.clientArea = rectangle2;
            GLDrawableImpl gLDrawableImpl = this.drawable;
            if (null != gLDrawableImpl) {
                if (DEBUG) {
                    System.err.println("GLCanvas.sizeChanged: (" + Thread.currentThread().getName() + "): " + rectangle2.width + "x" + rectangle2.height + " - surfaceHandle 0x" + Long.toHexString(this.getNativeSurface().getSurfaceHandle()));
                }
                if (!gLDrawableImpl.getChosenGLCapabilities().isOnscreen()) {
                    RecursiveLock recursiveLock = this.lock;
                    recursiveLock.lock();
                    try {
                        GLDrawableImpl gLDrawableImpl2 = GLDrawableHelper.resizeOffscreenDrawable(gLDrawableImpl, this.context, rectangle2.width, rectangle2.height);
                        if (gLDrawableImpl != gLDrawableImpl2) {
                            this.drawable = gLDrawableImpl2;
                        }
                    }
                    finally {
                        recursiveLock.unlock();
                    }
                    this.sendReshape = true;
                }
            }
        }
    }

    @Override
    public void display() {
        if (null != this.drawable || this.validateDrawableAndContext()) {
            GLCanvas.runInGLThread(this.makeCurrentAndDisplayOnEDTAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean validateDrawableAndContext() {
        boolean bl;
        if (this.isDisposed()) {
            return false;
        }
        Rectangle rectangle = this.clientArea;
        if (0 >= rectangle.width || 0 >= rectangle.height) {
            return false;
        }
        RecursiveLock recursiveLock = this.lock;
        recursiveLock.lock();
        try {
            ProxySurface proxySurface;
            GLDrawableFactory gLDrawableFactory;
            block9: {
                gLDrawableFactory = GLDrawableFactory.getFactory(this.capsRequested.getGLProfile());
                long l = SWTAccessor.getWindowHandle((Control)this);
                proxySurface = null;
                try {
                    proxySurface = gLDrawableFactory.createProxySurface(this.device, 0, l, this.capsRequested, this.capsChooser, this.swtCanvasUpStreamHook);
                }
                catch (GLException gLException) {
                    if (!DEBUG) break block9;
                    System.err.println(gLException.getMessage());
                }
            }
            if (null != proxySurface) {
                this.drawable = (GLDrawableImpl)gLDrawableFactory.createGLDrawable(proxySurface);
                this.drawable.setRealized(true);
                this.context = (GLContextImpl)this.drawable.createContext(this.shareWith);
            }
        }
        finally {
            recursiveLock.unlock();
        }
        boolean bl2 = bl = null != this.drawable;
        if (DEBUG && bl) {
            System.err.println("SWT GLCanvas realized! " + this + ", " + this.drawable);
            Thread.dumpStack();
        }
        return bl;
    }

    @Override
    public final Object getUpstreamWidget() {
        return this;
    }

    @Override
    public int getWidth() {
        return this.clientArea.width;
    }

    @Override
    public int getHeight() {
        return this.clientArea.height;
    }

    @Override
    public void addGLEventListener(GLEventListener gLEventListener) {
        this.helper.addGLEventListener(gLEventListener);
    }

    @Override
    public void addGLEventListener(int n, GLEventListener gLEventListener) throws IndexOutOfBoundsException {
        this.helper.addGLEventListener(n, gLEventListener);
    }

    @Override
    public void destroy() {
        this.dispose();
    }

    @Override
    public GLAnimatorControl getAnimator() {
        return this.helper.getAnimator();
    }

    @Override
    public boolean getAutoSwapBufferMode() {
        return this.helper.getAutoSwapBufferMode();
    }

    @Override
    public final GLDrawable getDelegatedDrawable() {
        return this.drawable;
    }

    @Override
    public GLContext getContext() {
        return null != this.drawable ? this.context : null;
    }

    @Override
    public int getContextCreationFlags() {
        return this.additionalCtxCreationFlags;
    }

    @Override
    public GL getGL() {
        GLContextImpl gLContextImpl = this.context;
        return null == gLContextImpl ? null : ((GLContext)gLContextImpl).getGL();
    }

    @Override
    public boolean invoke(boolean bl, GLRunnable gLRunnable) {
        return this.helper.invoke(this, bl, gLRunnable);
    }

    @Override
    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.helper.removeGLEventListener(gLEventListener);
    }

    @Override
    public GLEventListener removeGLEventListener(int n) throws IndexOutOfBoundsException {
        return this.helper.removeGLEventListener(n);
    }

    @Override
    public void setAnimator(GLAnimatorControl gLAnimatorControl) throws GLException {
        this.helper.setAnimator(gLAnimatorControl);
    }

    @Override
    public void setAutoSwapBufferMode(boolean bl) {
        this.helper.setAutoSwapBufferMode(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLContext setContext(GLContext gLContext) {
        RecursiveLock recursiveLock = this.lock;
        recursiveLock.lock();
        try {
            GLContextImpl gLContextImpl = this.context;
            boolean bl = GLDrawableHelper.switchContext(this.drawable, gLContextImpl, gLContext, this.additionalCtxCreationFlags);
            this.context = (GLContextImpl)gLContext;
            if (bl) {
                this.context.makeCurrent();
            }
            GLContextImpl gLContextImpl2 = gLContextImpl;
            return gLContextImpl2;
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public void setContextCreationFlags(int n) {
        this.additionalCtxCreationFlags = n;
        GLContextImpl gLContextImpl = this.context;
        if (null != gLContextImpl) {
            ((GLContext)gLContextImpl).setContextCreationFlags(this.additionalCtxCreationFlags);
        }
    }

    @Override
    public GL setGL(GL gL) {
        GLContextImpl gLContextImpl = this.context;
        if (null != gLContextImpl) {
            ((GLContext)gLContextImpl).setGL(gL);
            return gL;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLContext createContext(GLContext gLContext) {
        RecursiveLock recursiveLock = this.lock;
        recursiveLock.lock();
        try {
            if (this.drawable != null) {
                GLContext gLContext2 = this.drawable.createContext(gLContext);
                gLContext2.setContextCreationFlags(this.additionalCtxCreationFlags);
                GLContext gLContext3 = gLContext2;
                return gLContext3;
            }
            GLContext gLContext4 = null;
            return gLContext4;
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public GLCapabilitiesImmutable getChosenGLCapabilities() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getChosenGLCapabilities() : null;
    }

    public GLCapabilitiesImmutable getRequestedGLCapabilities() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? (GLCapabilitiesImmutable)gLDrawableImpl.getNativeSurface().getGraphicsConfiguration().getRequestedCapabilities() : null;
    }

    @Override
    public GLDrawableFactory getFactory() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return gLDrawableImpl != null ? gLDrawableImpl.getFactory() : null;
    }

    @Override
    public GLProfile getGLProfile() {
        return this.capsRequested.getGLProfile();
    }

    @Override
    public long getHandle() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return gLDrawableImpl != null ? gLDrawableImpl.getHandle() : 0L;
    }

    @Override
    public NativeSurface getNativeSurface() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return gLDrawableImpl != null ? gLDrawableImpl.getNativeSurface() : null;
    }

    @Override
    public boolean isRealized() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return gLDrawableImpl != null ? gLDrawableImpl.isRealized() : false;
    }

    @Override
    public void setRealized(boolean bl) {
    }

    @Override
    public void swapBuffers() throws GLException {
        GLCanvas.runInGLThread(this.swapBuffersOnEDTAction);
    }

    public void update() {
    }

    public void dispose() {
        GLCanvas.runInGLThread(this.disposeOnEDTGLAction);
        super.dispose();
    }

    private static void runInGLThread(Runnable runnable) {
        if (Platform.OSType.MACOS == Platform.OS_TYPE) {
            SWTAccessor.invoke(true, runnable);
        } else {
            Threading.invokeOnOpenGLThread(true, runnable);
        }
    }

    public static void main(String[] stringArray) {
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(GlueGenVersion.getInstance());
        System.err.println((Object)JoglVersion.getInstance());
        System.err.println(JoglVersion.getDefaultOpenGLInfo(null, null, true).toString());
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault(GLProfile.getDefaultDevice()));
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setSize(128, 128);
        shell.setLayout((Layout)new FillLayout());
        GLCanvas gLCanvas = new GLCanvas((Composite)shell, 0, gLCapabilities, null, null);
        gLCanvas.addGLEventListener(new GLEventListener(){

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
                GL gL = gLAutoDrawable.getGL();
                System.err.println(JoglVersion.getGLInfo(gL, null));
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }
        });
        shell.open();
        gLCanvas.display();
        display.dispose();
    }
}

