/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.util;

import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.nativewindow.util.SurfaceSize;

public class MonitorMode {
    SurfaceSize surfaceSize;
    DimensionImmutable screenSizeMM;
    int refreshRate;

    public MonitorMode(SurfaceSize surfaceSize, DimensionImmutable dimensionImmutable, int n) {
        if (null == surfaceSize) {
            throw new IllegalArgumentException("surfaceSize must be set (" + surfaceSize + ")");
        }
        this.surfaceSize = surfaceSize;
        this.screenSizeMM = dimensionImmutable;
        this.refreshRate = n;
    }

    public final SurfaceSize getSurfaceSize() {
        return this.surfaceSize;
    }

    public final DimensionImmutable getScreenSizeMM() {
        return this.screenSizeMM;
    }

    public final int getRefreshRate() {
        return this.refreshRate;
    }

    public final String toString() {
        return new String("[ " + this.surfaceSize + " x " + this.refreshRate + " Hz, " + this.screenSizeMM + " mm ]");
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MonitorMode) {
            MonitorMode monitorMode = (MonitorMode)object;
            return this.getSurfaceSize().equals(monitorMode.getSurfaceSize()) && this.getRefreshRate() == monitorMode.getRefreshRate();
        }
        return false;
    }

    public final int hashCode() {
        int n = 31 + this.getSurfaceSize().hashCode();
        n = (n << 5) - n + this.getRefreshRate();
        return n;
    }
}

