/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.cpd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.CPDNullListener;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokens;
import org.sonar.duplications.cpd.Match;
import org.sonar.duplications.cpd.MatchCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchAlgorithm {
    private static final int MOD = 37;
    private int lastHash;
    private int lastMod = 1;
    private List<Match> matches;
    private Map<String, SourceCode> source;
    private Tokens tokens;
    private List<TokenEntry> code;
    private CPDListener cpdListener;
    private int min;
    private boolean loadSourceCodeSlices = true;

    public MatchAlgorithm(Map<String, SourceCode> sourceCode, Tokens tokens, int min) {
        this(sourceCode, tokens, min, new CPDNullListener());
    }

    public MatchAlgorithm(Map<String, SourceCode> sourceCode, Tokens tokens, int min, CPDListener listener) {
        this.source = sourceCode;
        this.tokens = tokens;
        this.code = tokens.getTokens();
        this.min = min;
        this.cpdListener = listener;
        for (int i = 0; i < min; ++i) {
            this.lastMod *= 37;
        }
    }

    public void setLoadSourceCodeSlices(boolean loadSourceCodeSlices) {
        this.loadSourceCodeSlices = loadSourceCodeSlices;
    }

    public void setListener(CPDListener listener) {
        this.cpdListener = listener;
    }

    public Iterator<Match> matches() {
        return this.matches.iterator();
    }

    public TokenEntry tokenAt(int offset, TokenEntry m) {
        return this.code.get(offset + m.getIndex());
    }

    public int getMinimumTileSize() {
        return this.min;
    }

    public void findMatches() {
        this.cpdListener.phaseUpdate(1);
        Map<TokenEntry, Object> markGroups = this.hash();
        this.cpdListener.phaseUpdate(2);
        MatchCollector matchCollector = new MatchCollector(this);
        Iterator<Object> i = markGroups.values().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof List) {
                List l = (List)o;
                Collections.reverse(l);
                matchCollector.collect(l);
            }
            i.remove();
        }
        this.cpdListener.phaseUpdate(3);
        this.matches = matchCollector.getMatches();
        matchCollector = null;
        for (Match match : this.matches) {
            Iterator<TokenEntry> occurrences = match.iterator();
            while (occurrences.hasNext()) {
                TokenEntry mark = occurrences.next();
                match.setLineCount(this.tokens.getLineCount(mark, match));
                if (!this.loadSourceCodeSlices || occurrences.hasNext()) continue;
                int start = mark.getBeginLine();
                int end = start + match.getLineCount() - 1;
                SourceCode sourceCode = this.source.get(mark.getTokenSrcID());
                match.setSourceCodeSlice(sourceCode.getSlice(start, end));
            }
        }
        this.cpdListener.phaseUpdate(4);
    }

    private Map<TokenEntry, Object> hash() {
        HashMap<TokenEntry, Object> markGroups = new HashMap<TokenEntry, Object>(this.tokens.size());
        block0: for (int i = this.code.size() - 1; i >= 0; --i) {
            TokenEntry token = this.code.get(i);
            if (token != TokenEntry.EOF) {
                ArrayList<TokenEntry> l;
                int last = this.tokenAt(this.min, token).getIdentifier();
                this.lastHash = 37 * this.lastHash + token.getIdentifier() - this.lastMod * last;
                token.setHashCode(this.lastHash);
                Object o = markGroups.get(token);
                if (o == null) {
                    markGroups.put(token, token);
                    continue;
                }
                if (o instanceof TokenEntry) {
                    l = new ArrayList<TokenEntry>();
                    l.add((TokenEntry)o);
                    l.add(token);
                    markGroups.put(token, l);
                    continue;
                }
                l = (ArrayList<TokenEntry>)o;
                l.add(token);
                continue;
            }
            this.lastHash = 0;
            int end = Math.max(0, i - this.min + 1);
            while (i > end) {
                token = this.code.get(i - 1);
                this.lastHash = 37 * this.lastHash + token.getIdentifier();
                if (token == TokenEntry.EOF) continue block0;
                --i;
            }
        }
        return markGroups;
    }
}

