/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.RuleFailureModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.Project;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.Violation;
import org.sonar.batch.index.ResourcePersister;

public final class ViolationPersister {
    private DatabaseSession session;
    private ResourcePersister resourcePersister;
    private RuleFinder ruleFinder;

    public ViolationPersister(DatabaseSession session, ResourcePersister resourcePersister, RuleFinder ruleFinder) {
        this.session = session;
        this.resourcePersister = resourcePersister;
        this.ruleFinder = ruleFinder;
    }

    void saveViolation(Project project, Violation violation) {
        this.saveOrUpdateViolation(project, violation, null, null);
    }

    public void saveOrUpdateViolation(Project project, Violation violation, RuleFailureModel model, String checksum) {
        Snapshot snapshot = this.resourcePersister.saveResource(project, violation.getResource());
        if (model != null) {
            model = (RuleFailureModel)this.session.reattach(RuleFailureModel.class, (Object)model.getId());
            model = this.mergeModel(violation, model);
        } else {
            model = this.createModel(violation);
            model.setCreatedAt(snapshot.getCreatedAt());
        }
        model.setSnapshotId(snapshot.getId());
        model.setChecksum(checksum);
        this.session.save((Object)model);
        violation.setMessage(model.getMessage());
        violation.setCreatedAt(model.getCreatedAt());
    }

    private RuleFailureModel createModel(Violation violation) {
        return this.mergeModel(violation, new RuleFailureModel());
    }

    private RuleFailureModel mergeModel(Violation violation, RuleFailureModel merge) {
        Rule rule = this.ruleFinder.findByKey(violation.getRule().getRepositoryKey(), violation.getRule().getKey());
        merge.setRuleId(rule.getId());
        merge.setPriority(violation.getPriority());
        merge.setLine(violation.getLineId());
        merge.setMessage(violation.getMessage());
        merge.setCost(violation.getCost());
        return merge;
    }
}

