/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.api.batch.BatchExtensionDictionnary;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.FormulaDecorator;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratorsSelector {
    private BatchExtensionDictionnary dictionnary;

    public DecoratorsSelector(BatchExtensionDictionnary dictionnary) {
        this.dictionnary = dictionnary;
    }

    public Collection<Decorator> select(Project project) {
        ArrayList<Decorator> decorators = new ArrayList<Decorator>(this.dictionnary.select(Decorator.class, project, false));
        Set<Metric> coveredMetrics = this.getMetricsCoveredByPlugins(decorators);
        for (Metric metric : this.dictionnary.select(Metric.class)) {
            if (metric.getFormula() == null || coveredMetrics.contains(metric)) continue;
            decorators.add((Decorator)new FormulaDecorator(metric));
        }
        return this.dictionnary.sort(decorators);
    }

    private Set<Metric> getMetricsCoveredByPlugins(Collection<Decorator> pluginDecorators) {
        HashSet<Metric> coveredMetrics = new HashSet<Metric>();
        for (Decorator pluginDecorator : pluginDecorators) {
            List dependents = this.dictionnary.getDependents((Object)pluginDecorator);
            for (Object dependent : dependents) {
                if (!(dependent instanceof Metric)) continue;
                coveredMetrics.add((Metric)dependent);
            }
        }
        return coveredMetrics;
    }
}

