/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.list;

import java.util.LinkedList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class CvsListConsumer
implements StreamConsumer {
    private ScmLogger m_logger;
    private List m_entries;

    public CvsListConsumer(ScmLogger logger) {
        this.m_logger = logger;
        this.m_entries = new LinkedList();
    }

    public void consumeLine(String i_line) {
        String[] params;
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug(i_line);
        }
        if ((params = i_line.split("/")).length < 2) {
            if (StringUtils.isNotEmpty((String)i_line) && this.m_logger.isWarnEnabled()) {
                this.m_logger.warn("Unable to parse it as CVS/Entries format: " + i_line + ".");
            }
        } else {
            this.m_entries.add(new ScmFile(params[1], ScmFileStatus.UNKNOWN));
        }
    }

    public List getEntries() {
        return this.m_entries;
    }
}

