/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.export;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.export.AbstractExportCommand;
import org.apache.maven.scm.command.export.ExportScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.command.CvsCommandUtils;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Commandline;

public abstract class AbstractCvsExportCommand
extends AbstractExportCommand {
    protected ExportScmResult executeExportCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion version, String outputDirectory) throws ScmException {
        CvsScmProviderRepository repository = (CvsScmProviderRepository)repo;
        Commandline cl = CvsCommandUtils.getBaseCommand("export", repository, fileSet);
        if (version != null && StringUtils.isNotEmpty((String)version.getName())) {
            cl.createArgument().setValue("-r" + version.getName());
        } else {
            cl.createArgument().setValue("-rHEAD");
        }
        if (StringUtils.isNotEmpty((String)outputDirectory)) {
            cl.createArgument().setValue("-d");
            cl.createArgument().setValue(outputDirectory);
        }
        cl.createArgument().setValue(repository.getModule());
        this.getLogger().info("Executing: " + cl);
        this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        return this.executeCvsCommand(cl);
    }

    protected abstract ExportScmResult executeCvsCommand(Commandline var1) throws ScmException;
}

