/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.clearcase.command.tag;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.clearcase.command.ClearCaseCommand;
import org.apache.maven.scm.provider.clearcase.command.checkin.ClearCaseCheckInConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ClearCaseTagCommand
extends AbstractTagCommand
implements ClearCaseCommand {
    protected ScmResult executeTagCommand(ScmProviderRepository scmProviderRepository, ScmFileSet fileSet, String tag) throws ScmException {
        int exitCode;
        this.getLogger().debug("executing tag command...");
        Commandline cl = ClearCaseTagCommand.createCommandLine(fileSet, tag);
        ClearCaseCheckInConsumer consumer = new ClearCaseCheckInConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        try {
            this.getLogger().debug("Creating label: " + tag);
            Commandline newLabelCommandLine = ClearCaseTagCommand.createNewLabelCommandLine(fileSet, tag);
            this.getLogger().debug("Executing: " + newLabelCommandLine.getWorkingDirectory().getAbsolutePath() + ">>" + newLabelCommandLine.toString());
            exitCode = CommandLineUtils.executeCommandLine((Commandline)newLabelCommandLine, (StreamConsumer)new CommandLineUtils.StringStreamConsumer(), (StreamConsumer)stderr);
            if (exitCode == 0) {
                this.getLogger().debug("Executing: " + cl.getWorkingDirectory().getAbsolutePath() + ">>" + cl.toString());
                exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
            }
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing clearcase command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new TagScmResult(cl.toString(), "The cleartool command failed.", stderr.getOutput(), false);
        }
        return new TagScmResult(cl.toString(), consumer.getCheckedInFiles());
    }

    public static Commandline createCommandLine(ScmFileSet scmFileSet, String tag) {
        Commandline command = new Commandline();
        File workingDirectory = scmFileSet.getBasedir();
        command.setWorkingDirectory(workingDirectory.getAbsolutePath());
        command.setExecutable("cleartool");
        command.createArgument().setValue("mklabel");
        File[] files = scmFileSet.getFiles();
        if (files.length == 0) {
            command.createArgument().setValue("-recurse");
        }
        command.createArgument().setValue(tag);
        if (files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                command.createArgument().setValue(file.getName());
            }
        } else {
            command.createArgument().setValue(".");
        }
        return command;
    }

    private static Commandline createNewLabelCommandLine(ScmFileSet scmFileSet, String tag) {
        Commandline command = new Commandline();
        File workingDirectory = scmFileSet.getBasedir();
        command.setWorkingDirectory(workingDirectory.getAbsolutePath());
        command.setExecutable("cleartool");
        command.createArgument().setValue("mklbtype");
        command.createArgument().setValue("-nc");
        command.createArgument().setValue(tag);
        return command;
    }
}

