/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.clearcase.command.checkout;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.clearcase.command.ClearCaseCommand;
import org.apache.maven.scm.provider.clearcase.command.checkout.ClearCaseCheckOutConsumer;
import org.apache.maven.scm.provider.clearcase.repository.ClearCaseScmProviderRepository;
import org.apache.maven.scm.provider.clearcase.util.ClearCaseUtil;
import org.apache.maven.scm.providers.clearcase.settings.Settings;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ClearCaseCheckOutCommand
extends AbstractCheckOutCommand
implements ClearCaseCommand {
    private static Settings settings = ClearCaseUtil.getSettings();

    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repository, ScmFileSet fileSet, String tag) throws ScmException {
        int exitCode;
        Commandline cl;
        this.getLogger().debug("executing checkout command...");
        ClearCaseScmProviderRepository repo = (ClearCaseScmProviderRepository)repository;
        File workingDirectory = fileSet.getBasedir();
        this.getLogger().debug("tag: " + tag);
        if (ClearCaseCheckOutCommand.isClearCaseLT()) {
            this.getLogger().debug("Running with CLEARCASE LT");
        } else {
            this.getLogger().debug("Running with CLEARCASE");
        }
        ClearCaseCheckOutConsumer consumer = new ClearCaseCheckOutConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        try {
            FileUtils.deleteDirectory((File)workingDirectory);
            String viewName = ClearCaseCheckOutCommand.getUniqueViewName(repo, workingDirectory.getAbsolutePath());
            cl = ClearCaseCheckOutCommand.createCreateViewCommandLine(workingDirectory, viewName);
            this.getLogger().debug("Executing: " + cl.getWorkingDirectory().getAbsolutePath() + ">>" + cl.toString());
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)new CommandLineUtils.StringStreamConsumer(), (StreamConsumer)stderr);
            if (exitCode == 0) {
                if (tag != null) {
                    throw new UnsupportedOperationException("Building on a label not supported yet");
                }
                File configSpecLocation = repo.getConfigSpec();
                cl = ClearCaseCheckOutCommand.createUpdateConfigSpecCommandLine(workingDirectory, configSpecLocation, viewName);
                this.getLogger().debug("Executing: " + cl.getWorkingDirectory().getAbsolutePath() + ">>" + cl.toString());
                exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
            }
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing clearcase command.", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new ScmException("Error while deleting working directory.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new CheckOutScmResult(cl.toString(), "The cleartool command failed.", stderr.getOutput(), false);
        }
        return new CheckOutScmResult(cl.toString(), consumer.getCheckedOutFiles());
    }

    private static Commandline createDeleteViewCommandLine(ClearCaseScmProviderRepository repository, File workingDirectory) {
        Commandline command = new Commandline();
        command.setWorkingDirectory(workingDirectory.getAbsolutePath());
        command.setExecutable("cleartool");
        command.createArgument().setValue("rmview");
        command.createArgument().setValue("-force");
        command.createArgument().setValue("-tag");
        if (ClearCaseCheckOutCommand.isClearCaseLT()) {
            command.createArgument().setValue(ClearCaseCheckOutCommand.getViewStore());
        } else {
            command.createArgument().setValue(ClearCaseCheckOutCommand.getUniqueViewName(repository, workingDirectory.getAbsolutePath()));
        }
        return command;
    }

    protected static Commandline createCreateViewCommandLine(File workingDirectory, String viewName) throws IOException {
        Commandline command = new Commandline();
        command.setWorkingDirectory(workingDirectory.getParentFile().getAbsolutePath());
        command.setExecutable("cleartool");
        command.createArgument().setValue("mkview");
        command.createArgument().setValue("-snapshot");
        command.createArgument().setValue("-tag");
        command.createArgument().setValue(viewName);
        if (!ClearCaseCheckOutCommand.isClearCaseLT() && ClearCaseCheckOutCommand.useVWS()) {
            command.createArgument().setValue("-vws");
            command.createArgument().setValue(ClearCaseCheckOutCommand.getViewStore() + viewName + ".vws");
        }
        command.createArgument().setValue(workingDirectory.getCanonicalPath());
        return command;
    }

    protected static Commandline createUpdateConfigSpecCommandLine(File workingDirectory, File configSpecLocation, String viewName) {
        Commandline command = new Commandline();
        command.setWorkingDirectory(workingDirectory.getAbsolutePath());
        command.setExecutable("cleartool");
        command.createArgument().setValue("setcs");
        command.createArgument().setValue("-tag");
        command.createArgument().setValue(viewName);
        command.createArgument().setValue(configSpecLocation.getAbsolutePath());
        return command;
    }

    private static String getUniqueViewName(ClearCaseScmProviderRepository repository, String absolutePath) {
        int lastIndexBack = absolutePath.lastIndexOf(92);
        int lastIndexForward = absolutePath.lastIndexOf(47);
        String uniqueId = lastIndexBack != -1 ? absolutePath.substring(lastIndexBack + 1) : absolutePath.substring(lastIndexForward + 1);
        return repository.getViewName(uniqueId);
    }

    protected static String getViewStore() {
        String result = null;
        if (settings.getViewstore() != null) {
            result = settings.getViewstore();
        }
        if (result == null) {
            result = "\\\\" + ClearCaseCheckOutCommand.getHostName() + "\\viewstore\\";
        } else if (ClearCaseCheckOutCommand.isClearCaseLT()) {
            result = result + ClearCaseCheckOutCommand.getUserName() + "\\";
        }
        return result;
    }

    protected static boolean isClearCaseLT() {
        return settings.isClearcaseLT();
    }

    protected static void setIsClearCaseLT(boolean isClearCaseLT) {
        settings.setClearcaseLT(isClearCaseLT);
    }

    protected static boolean useVWS() {
        return settings.isUseVWSParameter();
    }

    protected static void setUseVWS(boolean useVWS) {
        settings.setUseVWSParameter(useVWS);
    }

    private static String getHostName() {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        return hostname;
    }

    private static String getUserName() {
        String username = System.getProperty("user.name");
        return username;
    }
}

