/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.bazaar.repository;

import java.io.File;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.codehaus.plexus.util.StringUtils;

public class BazaarScmProviderRepository
extends ScmProviderRepositoryWithHost {
    private static final String FILE = "file://";
    private static final String SFTP = "sftp://";
    private static final String FTP = "ftp://";
    private static final String AFTP = "aftp://";
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private static final String BZR = "bzr://";
    private static final String BZR_SSH = "bzr+ssh://";
    private static final String SSH = "ssh://";
    private static final String UNKNOWN = "";
    private final String path;
    private final String protocol;
    private final String orgUrl;

    public BazaarScmProviderRepository(String url) {
        this.orgUrl = url;
        this.protocol = this.getProtocol(url);
        this.path = this.parseUrl(url);
    }

    public String getURI() {
        if (FILE.equals(this.protocol)) {
            return this.orgUrl;
        }
        return this.protocol + (this.needsAuthentication() ? this.addUser() + this.addPassword() + this.addAt() : UNKNOWN) + this.addHost() + this.addPort() + this.addPath();
    }

    public String validateURI() {
        String msg = null;
        if (UNKNOWN.equals(this.protocol)) {
            msg = "Unknown protocol (URL should start with something like 'sftp://' or 'file://'";
        } else if (this.needsAuthentication()) {
            if (this.getUser() == null) {
                msg = "Username is missing for protocol " + this.protocol;
            } else if (this.getPassword() == null) {
                msg = "Password is missing for protocol " + this.protocol;
            } else if (this.getHost() == null) {
                msg = "Host (eg. www.myhost.com) is missing for protocol " + this.protocol;
            }
        } else if (this.getPort() != 0 && this.getHost() == null) {
            msg = "Got port information without any host for protocol " + this.protocol;
        }
        if (msg != null) {
            msg = "Something could be wrong about the repository URL: " + this.orgUrl + "\nReason: " + msg + "\nCheck http://maven.apache.org/scm for usage and hints.";
        }
        return msg;
    }

    private String getProtocol(String url) {
        String prot = UNKNOWN;
        if (url.startsWith(FILE)) {
            prot = FILE;
        } else if (url.startsWith(FTP)) {
            prot = FTP;
        } else if (url.startsWith(SFTP)) {
            prot = SFTP;
        } else if (url.startsWith(AFTP)) {
            prot = AFTP;
        } else if (url.startsWith(HTTP)) {
            prot = HTTP;
        } else if (url.startsWith(HTTPS)) {
            prot = HTTPS;
        } else if (url.startsWith(BZR)) {
            prot = BZR;
        } else if (url.startsWith(BZR_SSH)) {
            prot = BZR_SSH;
        } else if (url.startsWith(SSH)) {
            prot = SSH;
        }
        return prot;
    }

    private String parseUrl(String url) {
        if (UNKNOWN.equals(this.protocol)) {
            return url;
        }
        url = url.substring(this.protocol.length());
        url = this.parseUsernameAndPassword(url);
        url = this.parseHostAndPort(url);
        url = this.parsePath(url);
        return url;
    }

    private String parseHostAndPort(String url) {
        if (!FILE.equals(this.protocol)) {
            int indexColon;
            int indexSlash = url.indexOf("/");
            String hostPort = url;
            if (indexSlash > 0) {
                hostPort = url.substring(0, indexSlash);
            }
            if ((indexColon = hostPort.indexOf(":")) > 0) {
                this.setHost(hostPort.substring(0, indexColon));
                url = StringUtils.replace((String)url, (String)this.getHost(), (String)UNKNOWN);
                this.setPort(Integer.parseInt(hostPort.substring(indexColon + 1)));
                url = StringUtils.replace((String)url, (String)(":" + this.getPort()), (String)UNKNOWN);
            } else {
                this.setHost(hostPort);
                url = StringUtils.replace((String)url, (String)this.getHost(), (String)UNKNOWN);
            }
        }
        return url;
    }

    private String parseUsernameAndPassword(String url) {
        String[] split;
        if (this.needsAuthentication() && (split = url.split("@")).length == 2) {
            url = split[1];
            if ((split = split[0].split(":")).length == 2) {
                this.setUser(split[0]);
                this.setPassword(split[1]);
            } else {
                this.setUser(split[0]);
            }
        }
        return url;
    }

    private String parsePath(String url) {
        if (FILE.equals(this.protocol)) {
            url = StringUtils.replace((String)url, (String)"/", (String)File.separator);
            File tmpFile = new File(url);
            String url2 = url.substring(File.pathSeparator.length());
            File tmpFile2 = new File(url2);
            if (tmpFile.exists() || !tmpFile2.exists()) {
                // empty if block
            }
            url = tmpFile2.exists() ? url2 : url;
            url = StringUtils.replace((String)url, (String)File.separator, (String)"/");
        }
        return url;
    }

    private String addUser() {
        return this.getUser() == null ? UNKNOWN : this.getUser();
    }

    private String addPassword() {
        return this.getPassword() == null ? UNKNOWN : ":" + this.getPassword();
    }

    private String addAt() {
        return this.needsAuthentication() ? "@" : UNKNOWN;
    }

    private String addHost() {
        return this.getHost() == null ? UNKNOWN : this.getHost();
    }

    private String addPort() {
        return this.getPort() == 0 ? UNKNOWN : ":" + this.getPort();
    }

    private String addPath() {
        return this.path;
    }

    private boolean needsAuthentication() {
        return SFTP.equals(this.protocol) || FTP.equals(this.protocol) || HTTPS.equals(this.protocol) || AFTP.equals(this.protocol) || BZR.equals(this.protocol) || BZR_SSH.equals(this.protocol) || SSH.equals(this.protocol);
    }

    public String toString() {
        return "Bazaar Repository Interpreted from: " + this.orgUrl + ":\nProtocol: " + this.protocol + "\nHost: " + this.getHost() + "\nPort: " + this.getPort() + "\nUsername: " + this.getUser() + "\nPassword: " + this.getPassword() + "\nPath: " + this.path;
    }
}

