/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Site;
import org.apache.maven.project.inheritance.DefaultModelInheritanceAssembler;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public final class ModelUtils {
    public static void mergePluginLists(PluginContainer childContainer, PluginContainer parentContainer, boolean handleAsInheritance) {
        if (childContainer == null || parentContainer == null) {
            return;
        }
        List parentPlugins = parentContainer.getPlugins();
        if (parentPlugins != null && !parentPlugins.isEmpty()) {
            TreeMap<String, Plugin> assembledPlugins = new TreeMap<String, Plugin>();
            Map childPlugins = childContainer.getPluginsAsMap();
            Iterator<Object> it = parentPlugins.iterator();
            while (it.hasNext()) {
                Plugin parentPlugin = (Plugin)it.next();
                String parentInherited = parentPlugin.getInherited();
                if (handleAsInheritance && parentInherited != null && !Boolean.valueOf(parentInherited).booleanValue()) continue;
                Plugin assembledPlugin = parentPlugin;
                Plugin childPlugin = (Plugin)childPlugins.get(parentPlugin.getKey());
                if (childPlugin != null) {
                    assembledPlugin = childPlugin;
                    ModelUtils.mergePluginDefinitions(childPlugin, parentPlugin, handleAsInheritance);
                }
                if (handleAsInheritance && parentInherited == null) {
                    assembledPlugin.unsetInheritanceApplied();
                }
                assembledPlugins.put(assembledPlugin.getKey(), assembledPlugin);
            }
            it = childPlugins.values().iterator();
            while (it.hasNext()) {
                Plugin childPlugin = (Plugin)it.next();
                if (assembledPlugins.containsKey(childPlugin.getKey())) continue;
                assembledPlugins.put(childPlugin.getKey(), childPlugin);
            }
            childContainer.setPlugins(new ArrayList(assembledPlugins.values()));
            childContainer.flushPluginMap();
        }
    }

    public static void mergeReportPluginLists(Reporting child, Reporting parent, boolean handleAsInheritance) {
        if (child == null || parent == null) {
            return;
        }
        List parentPlugins = parent.getPlugins();
        if (parentPlugins != null && !parentPlugins.isEmpty()) {
            TreeMap<String, ReportPlugin> assembledPlugins = new TreeMap<String, ReportPlugin>();
            Map childPlugins = child.getReportPluginsAsMap();
            Iterator<Object> it = parentPlugins.iterator();
            while (it.hasNext()) {
                ReportPlugin parentPlugin = (ReportPlugin)it.next();
                String parentInherited = parentPlugin.getInherited();
                if (handleAsInheritance && parentInherited != null && !Boolean.valueOf(parentInherited).booleanValue()) continue;
                ReportPlugin assembledPlugin = parentPlugin;
                ReportPlugin childPlugin = (ReportPlugin)childPlugins.get(parentPlugin.getKey());
                if (childPlugin != null) {
                    assembledPlugin = childPlugin;
                    ModelUtils.mergeReportPluginDefinitions(childPlugin, parentPlugin, handleAsInheritance);
                }
                if (handleAsInheritance && parentInherited == null) {
                    assembledPlugin.unsetInheritanceApplied();
                }
                assembledPlugins.put(assembledPlugin.getKey(), assembledPlugin);
            }
            it = childPlugins.values().iterator();
            while (it.hasNext()) {
                ReportPlugin childPlugin = (ReportPlugin)it.next();
                if (assembledPlugins.containsKey(childPlugin.getKey())) continue;
                assembledPlugins.put(childPlugin.getKey(), childPlugin);
            }
            child.setPlugins(new ArrayList(assembledPlugins.values()));
            child.flushReportPluginMap();
        }
    }

    public static void mergePluginDefinitions(Plugin child, Plugin parent, boolean handleAsInheritance) {
        if (child == null || parent == null) {
            return;
        }
        if (parent.isExtensions()) {
            child.setExtensions(true);
        }
        if (child.getVersion() == null && parent.getVersion() != null) {
            child.setVersion(parent.getVersion());
        }
        Xpp3Dom childConfiguration = (Xpp3Dom)child.getConfiguration();
        Xpp3Dom parentConfiguration = (Xpp3Dom)parent.getConfiguration();
        childConfiguration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)childConfiguration, (Xpp3Dom)parentConfiguration);
        child.setConfiguration((Object)childConfiguration);
        String parentInherited = parent.getInherited();
        boolean parentIsInherited = parentInherited == null || Boolean.valueOf(parentInherited) != false;
        List parentExecutions = parent.getExecutions();
        if (parentExecutions != null && !parentExecutions.isEmpty()) {
            TreeMap<String, Object> assembledExecutions = new TreeMap<String, Object>();
            Map childExecutions = child.getExecutionsAsMap();
            Iterator<Object> it = parentExecutions.iterator();
            while (it.hasNext()) {
                PluginExecution parentExecution = (PluginExecution)it.next();
                if (handleAsInheritance && !parentIsInherited) continue;
                PluginExecution assembled = parentExecution;
                PluginExecution childExecution = (PluginExecution)childExecutions.get(parentExecution.getId());
                if (childExecution != null) {
                    ModelUtils.mergePluginExecutionDefinitions(childExecution, parentExecution);
                    assembled = childExecution;
                } else if (handleAsInheritance && parentInherited == null) {
                    parentExecution.unsetInheritanceApplied();
                }
                assembledExecutions.put(assembled.getId(), assembled);
            }
            it = childExecutions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String id = (String)entry.getKey();
                if (assembledExecutions.containsKey(id)) continue;
                assembledExecutions.put(id, entry.getValue());
            }
            child.setExecutions(new ArrayList(assembledExecutions.values()));
            child.flushExecutionMap();
        }
    }

    public static void mergeReportPluginDefinitions(ReportPlugin child, ReportPlugin parent, boolean handleAsInheritance) {
        String parentInherited;
        if (child == null || parent == null) {
            return;
        }
        if (child.getVersion() == null && parent.getVersion() != null) {
            child.setVersion(parent.getVersion());
        }
        boolean parentIsInherited = (parentInherited = parent.getInherited()) == null || Boolean.valueOf(parentInherited) != false;
        List parentReportSets = parent.getReportSets();
        if (parentReportSets != null && !parentReportSets.isEmpty()) {
            TreeMap<String, Object> assembledReportSets = new TreeMap<String, Object>();
            Map childReportSets = child.getReportSetsAsMap();
            Iterator<Object> it = parentReportSets.iterator();
            while (it.hasNext()) {
                ReportSet parentReportSet = (ReportSet)it.next();
                if (handleAsInheritance && !parentIsInherited) continue;
                ReportSet assembledReportSet = parentReportSet;
                ReportSet childReportSet = (ReportSet)childReportSets.get(parentReportSet.getId());
                if (childReportSet != null) {
                    ModelUtils.mergeReportSetDefinitions(childReportSet, parentReportSet);
                    assembledReportSet = childReportSet;
                } else if (handleAsInheritance && parentInherited == null) {
                    parentReportSet.unsetInheritanceApplied();
                }
                assembledReportSets.put(assembledReportSet.getId(), assembledReportSet);
            }
            it = childReportSets.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String id = (String)entry.getKey();
                if (assembledReportSets.containsKey(id)) continue;
                assembledReportSets.put(id, entry.getValue());
            }
            child.setReportSets(new ArrayList(assembledReportSets.values()));
            child.flushReportSetMap();
        }
    }

    private static void mergePluginExecutionDefinitions(PluginExecution child, PluginExecution parent) {
        if (child.getPhase() == null) {
            child.setPhase(parent.getPhase());
        }
        List parentGoals = parent.getGoals();
        List childGoals = child.getGoals();
        ArrayList<String> goals = new ArrayList<String>();
        if (childGoals != null && !childGoals.isEmpty()) {
            goals.addAll(childGoals);
        }
        if (parentGoals != null) {
            Iterator goalIterator = parentGoals.iterator();
            while (goalIterator.hasNext()) {
                String goal = (String)goalIterator.next();
                if (goals.contains(goal)) continue;
                goals.add(goal);
            }
        }
        child.setGoals(goals);
        Xpp3Dom childConfiguration = (Xpp3Dom)child.getConfiguration();
        Xpp3Dom parentConfiguration = (Xpp3Dom)parent.getConfiguration();
        childConfiguration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)childConfiguration, (Xpp3Dom)parentConfiguration);
        child.setConfiguration((Object)childConfiguration);
    }

    private static void mergeReportSetDefinitions(ReportSet child, ReportSet parent) {
        List parentReports = parent.getReports();
        List childReports = child.getReports();
        ArrayList<String> reports = new ArrayList<String>();
        if (childReports != null && !childReports.isEmpty()) {
            reports.addAll(childReports);
        }
        if (parentReports != null) {
            Iterator i = parentReports.iterator();
            while (i.hasNext()) {
                String report = (String)i.next();
                if (reports.contains(report)) continue;
                reports.add(report);
            }
        }
        child.setReports(reports);
        Xpp3Dom childConfiguration = (Xpp3Dom)child.getConfiguration();
        Xpp3Dom parentConfiguration = (Xpp3Dom)parent.getConfiguration();
        childConfiguration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)childConfiguration, (Xpp3Dom)parentConfiguration);
        child.setConfiguration((Object)childConfiguration);
    }

    public static Model cloneModel(Model model) {
        Model newModel = new Model();
        DefaultModelInheritanceAssembler assembler = new DefaultModelInheritanceAssembler();
        newModel.setModelVersion(model.getModelVersion());
        newModel.setName(model.getName());
        newModel.setParent(ModelUtils.cloneParent(model.getParent()));
        newModel.setVersion(model.getVersion());
        newModel.setArtifactId(model.getArtifactId());
        newModel.setProperties(new Properties(model.getProperties()));
        newModel.setGroupId(model.getGroupId());
        newModel.setPackaging(model.getPackaging());
        newModel.setModules(ModelUtils.cloneModules(model.getModules()));
        newModel.setProfiles(ModelUtils.cloneProfiles(model.getProfiles()));
        assembler.copyModel(newModel, model);
        return newModel;
    }

    private static List cloneProfiles(List profiles) {
        if (profiles == null) {
            return profiles;
        }
        ArrayList<Profile> newProfiles = new ArrayList<Profile>(profiles.size());
        Iterator it = profiles.iterator();
        while (it.hasNext()) {
            Profile profile = (Profile)it.next();
            Profile newProfile = new Profile();
            newProfile.setId(profile.getId());
            newProfile.setActivation(ModelUtils.cloneProfileActivation(profile.getActivation()));
            newProfile.setBuild(ModelUtils.cloneProfileBuild(profile.getBuild()));
            newProfile.setDependencies(ModelUtils.cloneProfileDependencies(profile.getDependencies()));
            DependencyManagement dm = profile.getDependencyManagement();
            if (dm != null) {
                DependencyManagement newDM = new DependencyManagement();
                newDM.setDependencies(ModelUtils.cloneProfileDependencies(dm.getDependencies()));
                newProfile.setDependencyManagement(newDM);
            }
            newProfile.setDistributionManagement(ModelUtils.cloneProfileDistributionManagement(profile.getDistributionManagement()));
            List modules = profile.getModules();
            if (modules != null && !modules.isEmpty()) {
                newProfile.setModules(new ArrayList(modules));
            }
            newProfile.setPluginRepositories(ModelUtils.cloneProfileRepositories(profile.getPluginRepositories()));
            Properties props = profile.getProperties();
            if (props != null) {
                Properties newProps = new Properties();
                ((Hashtable)newProps).putAll(props);
                newProfile.setProperties(newProps);
            }
            newProfile.setReporting(ModelUtils.cloneProfileReporting(profile.getReporting()));
            newProfile.setReports(profile.getReports());
            newProfile.setRepositories(ModelUtils.cloneProfileRepositories(profile.getRepositories()));
            newProfile.setSource(profile.getSource());
            newProfiles.add(newProfile);
        }
        return newProfiles;
    }

    private static Reporting cloneProfileReporting(Reporting reporting) {
        Reporting newR = null;
        if (reporting != null) {
            newR = new Reporting();
            newR.setOutputDirectory(reporting.getOutputDirectory());
            List plugins = reporting.getPlugins();
            if (plugins != null) {
                ArrayList<ReportPlugin> newP = new ArrayList<ReportPlugin>(plugins.size());
                Iterator it = plugins.iterator();
                while (it.hasNext()) {
                    ReportPlugin plugin = (ReportPlugin)it.next();
                    ReportPlugin newPlugin = new ReportPlugin();
                    newPlugin.setArtifactId(plugin.getArtifactId());
                    newPlugin.setGroupId(plugin.getGroupId());
                    newPlugin.setVersion(plugin.getVersion());
                    newPlugin.setInherited(plugin.getInherited());
                    newPlugin.setReportSets(ModelUtils.cloneReportSets(plugin.getReportSets()));
                    newPlugin.setConfiguration(plugin.getConfiguration());
                    newP.add(newPlugin);
                }
                newR.setPlugins(newP);
            }
        }
        return newR;
    }

    private static List cloneReportSets(List sets) {
        ArrayList<ReportSet> newSets = null;
        if (sets != null) {
            newSets = new ArrayList<ReportSet>(sets.size());
            Iterator it = sets.iterator();
            while (it.hasNext()) {
                ReportSet set = (ReportSet)it.next();
                ReportSet newSet = new ReportSet();
                newSet.setConfiguration(set.getConfiguration());
                newSet.setId(set.getId());
                newSet.setInherited(set.getInherited());
                newSet.setReports(new ArrayList(set.getReports()));
                newSets.add(newSet);
            }
        }
        return newSets;
    }

    private static List cloneProfileRepositories(List repos) {
        ArrayList<Repository> newRepos = null;
        if (repos != null) {
            newRepos = new ArrayList<Repository>(repos.size());
            Iterator it = repos.iterator();
            while (it.hasNext()) {
                RepositoryPolicy snapPolicy;
                Repository repo = (Repository)it.next();
                Repository newRepo = new Repository();
                newRepo.setId(repo.getId());
                newRepo.setLayout(repo.getLayout());
                newRepo.setName(repo.getName());
                RepositoryPolicy releasePolicy = repo.getReleases();
                if (releasePolicy != null) {
                    RepositoryPolicy newPolicy = new RepositoryPolicy();
                    newPolicy.setEnabled(releasePolicy.isEnabled());
                    newPolicy.setChecksumPolicy(releasePolicy.getChecksumPolicy());
                    newPolicy.setUpdatePolicy(releasePolicy.getUpdatePolicy());
                    newRepo.setReleases(newPolicy);
                }
                if ((snapPolicy = repo.getSnapshots()) != null) {
                    RepositoryPolicy newPolicy = new RepositoryPolicy();
                    newPolicy.setEnabled(snapPolicy.isEnabled());
                    newPolicy.setChecksumPolicy(snapPolicy.getChecksumPolicy());
                    newPolicy.setUpdatePolicy(snapPolicy.getUpdatePolicy());
                    newRepo.setSnapshots(newPolicy);
                }
                newRepo.setUrl(repo.getUrl());
                newRepos.add(newRepo);
            }
        }
        return newRepos;
    }

    private static DistributionManagement cloneProfileDistributionManagement(DistributionManagement dm) {
        DistributionManagement newDM = null;
        if (dm != null) {
            DeploymentRepository sRepo;
            Site site;
            DeploymentRepository repo;
            newDM = new DistributionManagement();
            newDM.setDownloadUrl(dm.getDownloadUrl());
            newDM.setStatus(dm.getStatus());
            Relocation relocation = dm.getRelocation();
            if (relocation != null) {
                Relocation newR = new Relocation();
                newR.setArtifactId(relocation.getArtifactId());
                newR.setGroupId(relocation.getGroupId());
                newR.setMessage(relocation.getMessage());
                newR.setVersion(relocation.getVersion());
                newDM.setRelocation(newR);
            }
            if ((repo = dm.getRepository()) != null) {
                DeploymentRepository newRepo = new DeploymentRepository();
                newRepo.setId(repo.getId());
                newRepo.setLayout(repo.getLayout());
                newRepo.setName(repo.getName());
                newRepo.setUrl(repo.getUrl());
                newDM.setRepository(newRepo);
            }
            if ((site = dm.getSite()) != null) {
                Site newSite = new Site();
                newSite.setId(site.getId());
                newSite.setName(site.getName());
                newSite.setUrl(site.getUrl());
                newDM.setSite(newSite);
            }
            if ((sRepo = dm.getSnapshotRepository()) != null) {
                DeploymentRepository newRepo = new DeploymentRepository();
                newRepo.setId(sRepo.getId());
                newRepo.setLayout(sRepo.getLayout());
                newRepo.setName(sRepo.getName());
                newRepo.setUrl(sRepo.getUrl());
                newDM.setSnapshotRepository(newRepo);
            }
        }
        return newDM;
    }

    private static List cloneProfileDependencies(List dependencies) {
        ArrayList<Dependency> newDependencies = null;
        if (dependencies != null) {
            newDependencies = new ArrayList<Dependency>(dependencies.size());
            Iterator it = dependencies.iterator();
            while (it.hasNext()) {
                Dependency dep = (Dependency)it.next();
                Dependency newDep = new Dependency();
                newDep.setArtifactId(dep.getArtifactId());
                newDep.setClassifier(dep.getClassifier());
                newDep.setExclusions(ModelUtils.cloneDependencyExclusions(dep.getExclusions()));
                newDep.setGroupId(dep.getGroupId());
                newDep.setScope(dep.getScope());
                newDep.setSystemPath(dep.getSystemPath());
                newDep.setType(dep.getType());
                newDep.setVersion(dep.getVersion());
                newDependencies.add(newDep);
            }
        }
        return newDependencies;
    }

    private static List cloneDependencyExclusions(List ex) {
        ArrayList<Exclusion> newEx = null;
        if (ex != null) {
            newEx = new ArrayList<Exclusion>(ex.size());
            Iterator it = ex.iterator();
            while (it.hasNext()) {
                Exclusion exclusion = (Exclusion)it.next();
                Exclusion newExclusion = new Exclusion();
                newExclusion.setArtifactId(exclusion.getArtifactId());
                newExclusion.setGroupId(exclusion.getGroupId());
                newEx.add(newExclusion);
            }
        }
        return newEx;
    }

    private static BuildBase cloneProfileBuild(BuildBase build) {
        BuildBase newBuild = null;
        if (build != null) {
            newBuild = new BuildBase();
            newBuild.setDefaultGoal(build.getDefaultGoal());
            newBuild.setDirectory(build.getDirectory());
            newBuild.setFinalName(build.getFinalName());
            newBuild.setPluginManagement(ModelUtils.cloneProfilePluginManagement(build.getPluginManagement()));
            newBuild.setPlugins(ModelUtils.cloneProfilePlugins(build.getPlugins()));
            newBuild.setResources(ModelUtils.cloneProfileResources(build.getResources()));
            newBuild.setTestResources(ModelUtils.cloneProfileResources(build.getTestResources()));
        }
        return newBuild;
    }

    private static List cloneProfileResources(List resources) {
        ArrayList<Resource> newResources = null;
        if (resources != null) {
            newResources = new ArrayList<Resource>(resources.size());
            Iterator it = resources.iterator();
            while (it.hasNext()) {
                Resource resource = (Resource)it.next();
                Resource newResource = new Resource();
                newResource.setDirectory(resource.getDirectory());
                newResource.setExcludes(new ArrayList(resource.getExcludes()));
                newResource.setFiltering(resource.isFiltering());
                newResource.setIncludes(new ArrayList(resource.getIncludes()));
                newResource.setTargetPath(resource.getTargetPath());
                newResources.add(newResource);
            }
        }
        return newResources;
    }

    private static PluginManagement cloneProfilePluginManagement(PluginManagement pluginManagement) {
        PluginManagement newPM = null;
        if (pluginManagement != null) {
            newPM = new PluginManagement();
            List plugins = pluginManagement.getPlugins();
            newPM.setPlugins(ModelUtils.cloneProfilePlugins(plugins));
        }
        return newPM;
    }

    private static List cloneProfilePlugins(List plugins) {
        ArrayList<Plugin> newPlugins = null;
        if (plugins != null) {
            newPlugins = new ArrayList<Plugin>(plugins.size());
            Iterator it = plugins.iterator();
            while (it.hasNext()) {
                Plugin plugin = (Plugin)it.next();
                Plugin newPlugin = new Plugin();
                newPlugin.setArtifactId(plugin.getArtifactId());
                newPlugin.setExtensions(plugin.isExtensions());
                newPlugin.setGroupId(plugin.getGroupId());
                newPlugin.setInherited(plugin.getInherited());
                newPlugin.setVersion(plugin.getVersion());
                newPlugin.setConfiguration(plugin.getConfiguration());
                newPlugin.setExecutions(ModelUtils.cloneExecutions(plugin.getExecutions()));
                newPlugins.add(newPlugin);
            }
        }
        return newPlugins;
    }

    private static List cloneExecutions(List executions) {
        ArrayList<PluginExecution> newExecs = null;
        if (executions != null) {
            newExecs = new ArrayList<PluginExecution>(executions.size());
            Iterator it = executions.iterator();
            while (it.hasNext()) {
                PluginExecution exec = (PluginExecution)it.next();
                PluginExecution newExec = new PluginExecution();
                newExec.setConfiguration(exec.getConfiguration());
                newExec.setId(exec.getId());
                newExec.setInherited(exec.getInherited());
                newExec.setPhase(exec.getPhase());
                List goals = exec.getGoals();
                if (goals != null && !goals.isEmpty()) {
                    newExec.setGoals(new ArrayList(goals));
                }
                newExecs.add(newExec);
            }
        }
        return newExecs;
    }

    private static Activation cloneProfileActivation(Activation activation) {
        Activation newActivation = null;
        if (activation != null) {
            newActivation = new Activation();
            newActivation.setActiveByDefault(activation.isActiveByDefault());
            ActivationFile af = activation.getFile();
            if (af != null) {
                ActivationFile afNew = new ActivationFile();
                afNew.setExists(af.getExists());
                afNew.setMissing(af.getMissing());
                newActivation.setFile(afNew);
            }
            newActivation.setJdk(activation.getJdk());
            ActivationProperty ap = activation.getProperty();
            if (ap != null) {
                ActivationProperty newAp = new ActivationProperty();
                newAp.setName(ap.getName());
                newAp.setValue(ap.getValue());
                newActivation.setProperty(newAp);
            }
        }
        return newActivation;
    }

    private static List cloneModules(List modules) {
        if (modules == null) {
            return modules;
        }
        return new ArrayList(modules);
    }

    private static Parent cloneParent(Parent parent) {
        if (parent == null) {
            return parent;
        }
        Parent newParent = new Parent();
        newParent.setArtifactId(parent.getArtifactId());
        newParent.setGroupId(parent.getGroupId());
        newParent.setRelativePath(parent.getRelativePath());
        newParent.setVersion(parent.getVersion());
        return newParent;
    }

    public static List mergeRepositoryLists(List dominant, List recessive) {
        Repository repository;
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        Iterator it = dominant.iterator();
        while (it.hasNext()) {
            repository = (Repository)it.next();
            repositories.add(repository);
        }
        it = recessive.iterator();
        while (it.hasNext()) {
            repository = (Repository)it.next();
            if (repositories.contains(repository)) continue;
            repositories.add(repository);
        }
        return repositories;
    }

    public static void mergeExtensionLists(Build childBuild, Build parentBuild) {
        Iterator i = parentBuild.getExtensions().iterator();
        while (i.hasNext()) {
            Extension e = (Extension)i.next();
            if (childBuild.getExtensions().contains(e)) continue;
            childBuild.addExtension(e);
        }
    }

    public static void mergeResourceLists(List childResources, List parentResources) {
        Iterator i = parentResources.iterator();
        while (i.hasNext()) {
            Resource r = (Resource)i.next();
            if (childResources.contains(r)) continue;
            childResources.add(r);
        }
    }

    public static void mergeFilterLists(List childFilters, List parentFilters) {
        Iterator i = parentFilters.iterator();
        while (i.hasNext()) {
            String f = (String)i.next();
            if (childFilters.contains(f)) continue;
            childFilters.add(f);
        }
    }
}

