/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.IParametrizedElement;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.pogamut.shed.widget.editor.AddArgumentAction;
import cz.cuni.pogamut.shed.widget.editor.ArgumentsTableModel;
import cz.cuni.pogamut.shed.widget.editor.ArgumentsTableModelFactory;
import cz.cuni.pogamut.shed.widget.editor.ParametersTableModel;
import cz.cuni.pogamut.shed.widget.editor.RemoveArgumentAction;
import cz.cuni.pogamut.shed.widget.editor.TableArgument;
import cz.cuni.pogamut.shed.widget.editor.TableParameter;
import cz.cuni.pogamut.shed.widget.editor.VariableTable;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

class ParametrizedNodeEditor
extends JPanel {
    private final InplaceEditorProvider.EditorController editorController;
    private final JTextField nameTextField;
    private final JButton addVariable;
    private final JButton removeVariable;
    private final JTable parametersTable;
    private final ArgumentsTableModel argumentsModel;
    private final JTable argumentsTable;
    private final ParametersTableModel parametersModel;
    private final ActionListener addParameterListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object defaultValue;
            String title = "New parameter";
            NotifyDescriptor.InputLine parameterNameDialog = new NotifyDescriptor.InputLine("Specify name of the parameter (must start with $, e.g $foo)", title);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)parameterNameDialog) != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String parameterName = parameterNameDialog.getInputText().trim();
            if (!Result.isVariableName((String)parameterName)) {
                NotifyDescriptor.Message paramNameWrong = new NotifyDescriptor.Message((Object)"Wrong name of parameter.\nName must match regular expression: \\$[a-zA-Z]([_\\-a-zA-Z0-9])*");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)paramNameWrong);
                return;
            }
            NotifyDescriptor.InputLine defaultParameterValue = new NotifyDescriptor.InputLine("Specify the default value of the new parameter(string, integer, double, bool or nil):", title);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)defaultParameterValue) != NotifyDescriptor.OK_OPTION) {
                return;
            }
            try {
                String defaultValueString = defaultParameterValue.getInputText().trim();
                defaultValue = Result.parseValue((String)defaultValueString);
            }
            catch (ParseException ex) {
                NotifyDescriptor.Message paramNameWrong = new NotifyDescriptor.Message((Object)("Wrong default value of parameter.\nParsing error: " + ex.getMessage()));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)paramNameWrong);
                return;
            }
            int addIndex = ParametrizedNodeEditor.this.parametersTable.getSelectedRow();
            if (addIndex == -1) {
                addIndex = ParametrizedNodeEditor.this.parametersTable.getRowCount();
            }
            ParametrizedNodeEditor.this.parametersModel.addParameter(addIndex, parameterName, defaultValue);
            ParametrizedNodeEditor.this.editorController.notifyEditorComponentBoundsChanged();
        }
    };
    private final ActionListener removeVariableListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = ParametrizedNodeEditor.this.parametersTable.getSelectedRow();
            if (index != -1) {
                ParametrizedNodeEditor.this.parametersModel.deleteVariable(index);
            }
        }
    };

    public ParametrizedNodeEditor(IParametrizedElement parametrizedElement, TriggeredAction action, InplaceEditorProvider.EditorController controller, LapChain chain) {
        String elementName = parametrizedElement.getName();
        assert (elementName.equals(action.getName()));
        this.editorController = controller;
        this.setLayout(new BoxLayout(this, 3));
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.nameTextField = new JTextField();
        this.nameTextField.setText(elementName);
        this.add(this.nameTextField);
        this.addVariable = new JButton("Add parameter");
        this.addVariable.addActionListener(this.addParameterListener);
        this.add(this.addVariable);
        this.removeVariable = new JButton("Remove parameter");
        this.removeVariable.addActionListener(this.removeVariableListener);
        this.add(this.removeVariable);
        FormalParameters params = parametrizedElement.getParameters();
        Arguments args = action.getArguments();
        this.parametersModel = new ParametersTableModel(params, args);
        this.parametersTable = new VariableTable(this.parametersModel);
        this.add(this.parametersTable.getTableHeader());
        this.add(this.parametersTable);
        this.argumentsModel = ArgumentsTableModelFactory.createNodeModel(params, args);
        this.argumentsTable = new VariableTable(this.argumentsModel);
        JButton addArgBtn = new JButton("Add argument");
        AddArgumentAction addArgumentListener = new AddArgumentAction(this.argumentsTable, this.argumentsModel, controller, chain);
        addArgBtn.addActionListener(addArgumentListener);
        this.add(addArgBtn);
        JButton removeArgBtn = new JButton("Remove argument");
        RemoveArgumentAction removeArgumentListener = new RemoveArgumentAction(this.argumentsTable, this.argumentsModel);
        removeArgBtn.addActionListener(removeArgumentListener);
        this.add(removeArgBtn);
        this.add(this.argumentsTable.getTableHeader());
        this.add(this.argumentsTable);
    }

    String getElementName() {
        return this.nameTextField.getText().trim();
    }

    public List<TableParameter> getParameters() {
        return this.parametersModel.getParameters();
    }

    public List<TableArgument> getArguments() {
        return this.argumentsModel.getArguments();
    }
}

