/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.explorer;

import cz.cuni.pogamut.posh.explorer.Crawler;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.java.classpath.ClassPathProvider;

abstract class AbstractCrawler<T>
extends Crawler<T> {
    AbstractCrawler() {
    }

    protected final ClasspathInfo getClasspathInfo(Project project) {
        ClassPathProvider cpp = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        assert (cpp != null);
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        assert (sources != null);
        SourceGroup[] groups = sources.getSourceGroups("java");
        assert (groups.length != 0);
        SourceGroup group = groups[0];
        ClassPath bootPath = cpp.findClassPath(group.getRootFolder(), "classpath/boot");
        ClassPath compilePath = cpp.findClassPath(group.getRootFolder(), "classpath/compile");
        ClassPath srcPath = cpp.findClassPath(group.getRootFolder(), "classpath/source");
        return ClasspathInfo.create((ClassPath)bootPath, (ClassPath)compilePath, (ClassPath)srcPath);
    }

    protected final String getSimpleNameFromFQN(String fqn) {
        int lastIndex = fqn.lastIndexOf(".");
        if (lastIndex == -1) {
            return fqn;
        }
        return fqn.substring(lastIndex + 1);
    }

    protected final ElementHandle<TypeElement> getTypeOfClass(ClassIndex ci, String classfqn) {
        String searchedString = this.getSimpleNameFromFQN(classfqn);
        ClassIndex.NameKind kind = ClassIndex.NameKind.SIMPLE_NAME;
        EnumSet<ClassIndex.SearchScope> searchScope = EnumSet.of(ClassIndex.SearchScope.DEPENDENCIES, ClassIndex.SearchScope.SOURCE);
        Set res = ci.getDeclaredTypes(searchedString, kind, searchScope);
        for (ElementHandle eh : res) {
            String qn = eh.getQualifiedName();
            if (!classfqn.equals(qn)) continue;
            return eh;
        }
        return null;
    }

    protected final Set<ElementHandle<TypeElement>> getDirectSubtypes(ClassIndex ci, ElementHandle<TypeElement> ancestor) {
        EnumSet<ClassIndex.SearchKind> sk = EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS);
        EnumSet<ClassIndex.SearchScope> sc = EnumSet.of(ClassIndex.SearchScope.DEPENDENCIES, ClassIndex.SearchScope.SOURCE);
        return ci.getElements(ancestor, sk, sc);
    }

    protected final Set<ElementHandle<TypeElement>> getAllSubtypes(ClassIndex ci, ElementHandle<TypeElement> ancestorTE) {
        HashSet<ElementHandle<TypeElement>> result = new HashSet<ElementHandle<TypeElement>>();
        LinkedList<ElementHandle<TypeElement>> todo = new LinkedList<ElementHandle<TypeElement>>();
        todo.add(ancestorTE);
        while (!todo.isEmpty()) {
            ElementHandle curr = (ElementHandle)todo.removeFirst();
            Set<ElementHandle<TypeElement>> subtypesOfCurr = this.getDirectSubtypes(ci, (ElementHandle<TypeElement>)curr);
            if (subtypesOfCurr == null) continue;
            result.addAll(subtypesOfCurr);
            todo.addAll(subtypesOfCurr);
        }
        return result;
    }
}

