/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.executor.ParamInfo;
import cz.cuni.pogamut.shed.widget.editor.AddArgumentAction;
import cz.cuni.pogamut.shed.widget.editor.ArgumentsTableModel;
import cz.cuni.pogamut.shed.widget.editor.ArgumentsTableModelFactory;
import cz.cuni.pogamut.shed.widget.editor.RemoveArgumentAction;
import cz.cuni.pogamut.shed.widget.editor.TableArgument;
import cz.cuni.pogamut.shed.widget.editor.VariableTable;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.netbeans.api.visual.action.InplaceEditorProvider;

class ActionEditor
extends JPanel {
    private final JTextField nameTextField;
    private final ArgumentsTableModel argumentsModel;
    private final JTable argumentsTable;

    ActionEditor(TriggeredAction action, ParamInfo[] params, InplaceEditorProvider.EditorController controller, LapChain chain) {
        this.setLayout(new BoxLayout(this, 3));
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.nameTextField = new JTextField();
        this.nameTextField.setText(action.getName());
        this.add(this.nameTextField);
        this.argumentsModel = ArgumentsTableModelFactory.createLeafModel(params, action.getArguments());
        this.argumentsTable = new VariableTable(this.argumentsModel);
        JButton addArgBtn = new JButton("Add argument");
        AddArgumentAction addArgumentListener = new AddArgumentAction(this.argumentsTable, this.argumentsModel, controller, chain);
        addArgBtn.addActionListener(addArgumentListener);
        this.add(addArgBtn);
        JButton removeArgBtn = new JButton("Remove argument");
        RemoveArgumentAction removeArgumentListener = new RemoveArgumentAction(this.argumentsTable, this.argumentsModel);
        removeArgBtn.addActionListener(removeArgumentListener);
        this.add(removeArgBtn);
        this.add(this.argumentsTable.getTableHeader());
        this.add(this.argumentsTable);
    }

    String getActionName() {
        return this.nameTextField.getText().trim();
    }

    List<TableArgument> getArguments() {
        return this.argumentsModel.getArguments();
    }

    public void stopEditting() {
        Component editor = this.argumentsTable.getEditorComponent();
        if (editor instanceof JTextField) {
            String value = ((JTextField)editor).getText();
            int row = this.argumentsTable.getEditingRow();
            int column = this.argumentsTable.getEditingColumn();
            this.argumentsTable.setValueAt(value, row, column);
        }
    }
}

