/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import cz.cuni.amis.pogamut.sposh.executor.ParamInfo;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.widget.editor.SenseEditor;
import cz.cuni.pogamut.shed.widget.editor.ShedEditorProvider;
import java.text.MessageFormat;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.widget.Widget;

final class SenseEditorProvider
extends ShedEditorProvider<Sense, SenseEditor> {
    private final ShedPresenter presenter;

    public SenseEditorProvider(Sense sense, ShedPresenter presenter, LapChain chain) {
        super(sense, chain);
        this.presenter = presenter;
    }

    public void notifyClosing(InplaceEditorProvider.EditorController ec, Widget widget, SenseEditor editor, boolean commit) {
        if (commit) {
            editor.stopEditting();
            String oldName = ((Sense)this.node).getName();
            String newName = editor.getSenseName();
            if (!oldName.equals(newName)) {
                try {
                    ((Sense)this.node).setSenseName(newName);
                }
                catch (InvalidNameException ex) {
                    String errorMessage = MessageFormat.format("Name \"{0}\" is not valid", newName);
                    this.notify(errorMessage);
                }
            }
            ((Sense)this.node).setPredicate(editor.getPredicate());
            String operandString = editor.getOperandString();
            try {
                Object operand = Result.parseValue((String)operandString);
                ((Sense)this.node).setOperand(operand);
            }
            catch (ParseException ex) {
                this.notify("\"" + operandString + "\" is not a valid value.");
            }
            Arguments args = new Arguments();
            String unsuccessfull = this.convertEditorArg(editor.getArguments(), args);
            if (!unsuccessfull.isEmpty()) {
                this.notify("Following arguments had errors: \n" + unsuccessfull);
            }
            ((Sense)this.node).setArguments(args);
        }
    }

    public SenseEditor createEditorComponent(InplaceEditorProvider.EditorController controller, Widget widget) {
        ParamInfo[] params = this.presenter.getPrimitiveParameters(((Sense)this.node).getName());
        return new SenseEditor((Sense)this.node, params, controller, this.chain);
    }
}

