/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.executor.ParamInfo;
import cz.cuni.pogamut.shed.widget.editor.AddArgumentAction;
import cz.cuni.pogamut.shed.widget.editor.ArgumentsTableModel;
import cz.cuni.pogamut.shed.widget.editor.ArgumentsTableModelFactory;
import cz.cuni.pogamut.shed.widget.editor.RemoveArgumentAction;
import cz.cuni.pogamut.shed.widget.editor.TableArgument;
import cz.cuni.pogamut.shed.widget.editor.VariableTable;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.netbeans.api.visual.action.InplaceEditorProvider;

class SenseEditor
extends JPanel {
    private final JTextField nameTextField;
    private final ArgumentsTableModel argumentsModel;
    private final JComboBox predicateCombo;
    private final JTextField operandText;
    private final JTable argumentsTable;

    SenseEditor(Sense sense, ParamInfo[] params, InplaceEditorProvider.EditorController controller, LapChain chain) {
        this.setLayout(new BoxLayout(this, 3));
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.nameTextField = new JTextField();
        this.nameTextField.setText(sense.getName());
        this.add(this.nameTextField);
        this.predicateCombo = new JComboBox<Sense.Predicate>(Sense.Predicate.getPredicates());
        this.predicateCombo.setSelectedItem(sense.getPredicate());
        this.add(this.predicateCombo);
        this.operandText = new JTextField(Result.toLap((Object)sense.getOperand()));
        this.add(this.operandText);
        this.argumentsModel = ArgumentsTableModelFactory.createLeafModel(params, sense.getArguments());
        this.argumentsTable = new VariableTable(this.argumentsModel);
        JButton addArgBtn = new JButton("Add argument");
        AddArgumentAction addArgumentListener = new AddArgumentAction(this.argumentsTable, this.argumentsModel, controller, chain);
        addArgBtn.addActionListener(addArgumentListener);
        this.add(addArgBtn);
        JButton removeArgBtn = new JButton("Remove argument");
        RemoveArgumentAction removeArgumentListener = new RemoveArgumentAction(this.argumentsTable, this.argumentsModel);
        removeArgBtn.addActionListener(removeArgumentListener);
        this.add(removeArgBtn);
        this.add(this.argumentsTable.getTableHeader());
        this.add(this.argumentsTable);
    }

    String getSenseName() {
        return this.nameTextField.getText().trim();
    }

    Sense.Predicate getPredicate() {
        return (Sense.Predicate)this.predicateCombo.getSelectedItem();
    }

    String getOperandString() {
        return this.operandText.getText().trim();
    }

    List<TableArgument> getArguments() {
        return this.argumentsModel.getArguments();
    }

    public void stopEditting() {
        Component editor = this.argumentsTable.getEditorComponent();
        if (editor instanceof JTextField) {
            String value = ((JTextField)editor).getText();
            int row = this.argumentsTable.getEditingRow();
            int column = this.argumentsTable.getEditingColumn();
            this.argumentsTable.setValueAt(value, row, column);
        }
    }
}

