/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.INamedElement;
import cz.cuni.amis.pogamut.sposh.elements.IParametrizedElement;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.CycleException;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import cz.cuni.pogamut.shed.widget.editor.ParametrizedNodeEditor;
import cz.cuni.pogamut.shed.widget.editor.ShedEditorProvider;
import cz.cuni.pogamut.shed.widget.editor.TableArgument;
import cz.cuni.pogamut.shed.widget.editor.TableParameter;
import java.text.MessageFormat;
import java.util.List;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.widget.Widget;

public final class NodeEditorProvider<NODE extends INamedElement & IParametrizedElement>
extends ShedEditorProvider<NODE, ParametrizedNodeEditor> {
    private final TriggeredAction referencingAction;

    public NodeEditorProvider(NODE node, TriggeredAction referencingAction, LapChain chain) {
        super(node, chain);
        this.referencingAction = referencingAction;
    }

    public void notifyClosing(InplaceEditorProvider.EditorController ec, Widget widget, ParametrizedNodeEditor editor, boolean commit) {
        if (commit) {
            String newNodeName;
            String oldNodeName = ((INamedElement)this.node).getName();
            if (!oldNodeName.equals(newNodeName = editor.getElementName())) {
                String errorMessage;
                try {
                    ((INamedElement)this.node).rename(newNodeName);
                }
                catch (InvalidNameException ex) {
                    errorMessage = MessageFormat.format("Name \"{0}\" is not valid", newNodeName);
                    this.notify(errorMessage);
                }
                catch (CycleException ex) {
                    errorMessage = MessageFormat.format("Changing name to \"{0}\" would cause a cycle.", newNodeName);
                    this.notify(errorMessage);
                }
                catch (DuplicateNameException ex) {
                    errorMessage = MessageFormat.format("Name \"{0}\" is already used.", newNodeName);
                    this.notify(errorMessage);
                }
            }
            FormalParameters newParams = new FormalParameters();
            List<TableParameter> editorParams = editor.getParameters();
            for (TableParameter editorParam : editorParams) {
                String paramName = editorParam.getName();
                if (Result.isVariableName((String)editorParam.getDefaultValueString())) continue;
                Object paramDefaultValue = editorParam.getDefaultValue();
                newParams.add((Object)new FormalParameters.Parameter(paramName, paramDefaultValue));
            }
            ((IParametrizedElement)((INamedElement)this.node)).setParameters(newParams);
            Arguments newNodeArgs = this.getNodeArgs(editor.getArguments(), editorParams);
            this.referencingAction.setArguments(newNodeArgs);
        }
    }

    private Arguments getNodeArgs(List<TableArgument> editorArgs, List<TableParameter> editorParams) {
        Arguments newArgs = new Arguments();
        String unsuccessfullArgs = this.convertEditorArg(editorArgs, newArgs);
        String unsuccessfullParams = this.convertEditorParams(editorParams, newArgs);
        String unsuccessfull = unsuccessfullArgs + unsuccessfullParams;
        if (!unsuccessfull.isEmpty()) {
            this.notify("Following arguments had errors: \n" + unsuccessfull);
        }
        return newArgs;
    }

    public ParametrizedNodeEditor createEditorComponent(InplaceEditorProvider.EditorController controller, Widget widget) {
        return new ParametrizedNodeEditor((IParametrizedElement)this.node, this.referencingAction, controller, this.chain);
    }
}

