/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ParamInfo;
import cz.cuni.pogamut.shed.widget.editor.TableArgument;
import cz.cuni.pogamut.shed.widget.editor.TableArgumentFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TableArgument_createArgument {
    private VariableContext ctx;

    @Before
    public void setUp() {
        this.ctx = new VariableContext();
        this.ctx.put("$variable", (Object)"Value");
    }

    @After
    public void tearDown() {
        this.ctx = null;
    }

    @Test
    public void variableArgument() {
        TableArgument tabArg = new TableArgument("$arg", "$variable", null);
        Arguments.Argument arg = tabArg.createArgument(this.ctx);
        Assert.assertEquals((Object)"$variable", (Object)arg.getParameterVariable());
    }

    @Test(expected=IllegalStateException.class)
    public void nonexistentVariableArgument() {
        TableArgument tabArg = new TableArgument("$arg", "$nonexistent", null);
        tabArg.createArgument(this.ctx);
    }

    @Test(expected=IllegalStateException.class)
    public void blankArgument() {
        TableArgument tabArg = TableArgumentFactory.createBlank((ParamInfo)new ParamInfo("name", ParamInfo.Type.INT, Integer.TYPE.getName()));
        tabArg.createArgument(this.ctx);
    }

    @Test
    public void valueArgument() {
        TableArgument tabArg = new TableArgument("$arg", "\"value\"", null);
        Arguments.Argument arg = tabArg.createArgument(this.ctx);
        Assert.assertNull((Object)arg.getParameterVariable());
        Assert.assertEquals((Object)"value", (Object)arg.getValue());
    }

    @Test(expected=IllegalStateException.class)
    public void unparsableArgument() {
        TableArgument tabArg = new TableArgument("$arg", "ah\"oj1456", null);
        tabArg.createArgument(this.ctx);
    }
}

