package cz.cuni.pogamut.shed.widget;

import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import java.awt.Point;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.Widget;

/**
 * Envelope for visual representation of an slot element with trigger and
 * attachment action (={@link DriveElement}, {@link CompetenceElement} and {@link DriveElement}).
 *
 * @author HonzaH
 */
public abstract class SlotEnvelope extends Widget implements IShedEnvelope<ShedSenseWidget> {

    /**
     * Widget representing the slot element, e.g. competence element. It
     * displayes the name ect.
     */
    protected final ShedWidget slotWidget;
    private final ShedTriggerEnvelope triggerEnvelope;
    private ExpandedActionEnvelope expandedActionEnvelope;
    private final Widget top;

    public SlotEnvelope(ShedScene scene, ShedWidget slotWidget, ShedTriggerEnvelope triggerEnvelope, final ExpandedActionEnvelope expandedActionEnvelope) {
        super(scene);

        setLayout(LayoutFactory.createVerticalFlowLayout(LayoutFactory.SerialAlignment.LEFT_TOP, ShedWidgetFactory.VERTICAL_GAP));

        top = new Widget(scene);
        top.setLayout(LayoutFactory.createHorizontalFlowLayout(LayoutFactory.SerialAlignment.LEFT_TOP, ShedWidgetFactory.HORIZONTAL_GAP));

        assert slotWidget != null;
        this.slotWidget = slotWidget;
        top.addChild(slotWidget);

        assert triggerEnvelope != null;
        this.triggerEnvelope = triggerEnvelope;
        top.addChild(triggerEnvelope);

        addChild(top);

        assert expandedActionEnvelope != null;
        this.expandedActionEnvelope = expandedActionEnvelope;
        addChild(expandedActionEnvelope);
    }

    public ShedWidget getSlotWidget() {
        return slotWidget;
    }

    public ShedTriggerEnvelope getTriggerEnvelope() {
        return triggerEnvelope;
    }

    public ExpandedActionEnvelope getExpandedActionEnvelope() {
        return this.expandedActionEnvelope;
    }

    @Override
    public final void add(ShedSenseWidget widget, int position) {
        triggerEnvelope.add(widget, position);
    }

    @Override
    public final void move(int absolutePosition, ShedSenseWidget widget) {
        triggerEnvelope.move(absolutePosition, widget);
    }

    @Override
    public final void remove(ShedSenseWidget widget) {
        triggerEnvelope.remove(widget);
    }
}