/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.widget;

import cz.cuni.pogamut.posh.widget.PoshScene;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;

public class TrimmedLabelWidget
extends LabelWidget {
    private String originalText;
    private double maxWidth;

    public TrimmedLabelWidget(PoshScene scene, double maxWidth) {
        super((Scene)scene);
        this.maxWidth = maxWidth;
    }

    public void setLabel(String text) {
        this.originalText = text;
        super.setLabel(this.getTrimmedText(text, this.getGraphics(), this.maxWidth));
    }

    public String getText() {
        return this.originalText;
    }

    private String getTrimmedText(String text, Graphics2D g, double maxWidth) {
        FontRenderContext frc = g.getFontRenderContext();
        Rectangle2D rect = this.getFont().getStringBounds(text, frc);
        if (rect.getWidth() <= maxWidth) {
            return text;
        }
        text = text + "...";
        do {
            text = text.replaceFirst(".\\.\\.\\.$", "...");
        } while ((rect = this.getFont().getStringBounds(text, frc)).getWidth() > maxWidth && text.length() > 4);
        return text;
    }
}

