package cz.cuni.pogamut.posh.widget.structure;

import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.pogamut.posh.widget.PoshNodeType;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.posh.widget.kidview.AbstractMenuAction;
import cz.cuni.pogamut.posh.widget.accept.AcceptAP2Plan;
import cz.cuni.pogamut.posh.widget.accept.AcceptComp2Plan;
import cz.cuni.pogamut.posh.widget.menuactions.AddAP2Plan;
import cz.cuni.pogamut.posh.widget.menuactions.AddComp2Plan;
import java.beans.PropertyChangeEvent;
import java.util.LinkedList;
import java.util.List;

/**
 *
 * @author Honza
 */
public class StrRootWidget extends StrBasicWidget<PoshPlan> {

    public StrRootWidget(PoshScene poshScene, PoshPlan dataNode, PoshWidget parent) {
        super(poshScene, dataNode, parent);
    }

    @Override
    protected List<AbstractMenuAction> createMenuActions() {
        LinkedList<AbstractMenuAction> list = new LinkedList<AbstractMenuAction>();

        list.add(new AddComp2Plan(getDataNode()));
        list.add(new AddAP2Plan(getDataNode()));
        
        return list;
    }

    @Override
    protected void addChildWidget(PoshElement dataNode) {
        synchronizeDataNodeWidgets(dataNode);
    }

    @Override
    protected List<AbstractAcceptAction> getAcceptProviders() {
        List<AbstractAcceptAction> list = new LinkedList<AbstractAcceptAction>();

        list.add(new AcceptComp2Plan(getDataNode()));
        list.add(new AcceptAP2Plan(getDataNode()));

        return list;
    }

    @Override
    protected PoshNodeType getType() {
        return PoshNodeType.ROOT;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(PoshPlan.prName)) {
            this.setHeadlineText((String) evt.getNewValue());
        }
    }
}
