package cz.cuni.pogamut.posh.widget.kidview;

import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.CompetencePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.posh.widget.PoshNodeType;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.accept.AcceptCPE2CPE;
import cz.cuni.pogamut.posh.widget.accept.AcceptSense2CPE;
import cz.cuni.pogamut.posh.widget.menuactions.DeleteNodeAction;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.widget.Widget;
import org.openide.nodes.Node.Property;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

/**
 * Widget representing Competence Element and its only possible child CompetenceElement
 * (so this widget represents two data nodes) in KidView.
 *
 * @author Honza
 */
public class SimpleCompetenceElementWidget extends SimpleBasicWidget<CompetencePriorityElement> {

    /**
     * This is possible child. For now, we allow only one child CompetenceElement.
     * If no such child was specified, set to null.
     */
    private CompetenceElement compAtom;

    public SimpleCompetenceElementWidget(PoshScene poshScene, CompetencePriorityElement dataNode, PoshWidget parent) {
        super(poshScene, dataNode, parent);
    }

    /**
     * Inplace editor for changing the name of the CompetenceElement in the enclosing widget
     */
    private static class CompetenceElementInplaceEditor implements TextFieldInplaceEditor {

        private CompetenceElement ce;

        private CompetenceElementInplaceEditor(CompetenceElement ce) {
            this.ce = ce;
        }

        @Override
        public boolean isEnabled(Widget widget) {
            return true;
        }

        @Override
        public String getText(Widget widget) {
            return ce.getDisplayName();
        }

        @Override
        public void setText(Widget widget, String newCEName) {
            ce.setElementName(newCEName);
        }
    }

    @Override
    protected PoshNodeType getType() {
        return PoshNodeType.COMPETENCE_PRIORITY_ELEMENT;
    }

    /**
     * Competence atom data node if available, associated competence element
     * otherwise.
     * @return DriveElement is available, otherwise Drive
     */
    @Override
    protected synchronized PropertyNode createPropertiesNode() {
        PoshElement element = getDataNode();
        if (this.compAtom != null) {
            element = this.compAtom;
        }
        return new PropertyNode(element, this);
    }

    @Override
    protected List<AbstractMenuAction> createMenuActions() {
        LinkedList<AbstractMenuAction> list = new LinkedList<AbstractMenuAction>();

        if (this.compAtom != null) {
            list.add(new AbstractMenuAction<CompetenceElement>("Add trigger sense", getDataNode()) {

                @Override
                public void actionPerformed(ActionEvent e) {
                    String ident = this.getIdentifierFromDialog("Name of new trigger");
                    if (ident != null) {
                        compAtom.addTriggerAct(new Sense(ident));
                    }
                }
            });
        }

        int numEl = getDataNode().getParent().getNumberOfChildInstances(CompetencePriorityElement.class);

        if (numEl > 1) {
            list.add(
                    new DeleteNodeAction(
                    "Delete competence element",
                    getDataNode()));
        }
        return list;
    }

    /**
     * Create proper widget from child data node.
     *
     * @param dataNode DataNode that was added as child
     *                 to associated data node
     */
    @Override
    protected void addChildWidget(PoshElement dataNode) {
        if (dataNode instanceof CompetenceElement) {
//			System.out.println("+++ new CompetenceAtom for " + this.getName() + " " + dataNode.toString());

            this.compAtom = (CompetenceElement) dataNode;
            this.compAtom.addPoshTreeChangeListener(this);
            dataNode.addPoshTreeChangeListener(this);

            this.setHeadlineText(this.compAtom.getElementName());

            getActions().addAction(ActionFactory.createInplaceEditorAction(
                    new CompetenceElementInplaceEditor(compAtom)));
/*
            SimpleCompetenceAtomWidget cAtomW =
            new SimpleCompetenceAtomWidget(getPoshScene(), dataNode, this);

            this.getChildNodes().add(cAtomW);
            this.getPoshScene().addPoshWidget(cAtomW);
            this.getPoshScene().consolidate();
             */
        } else if (dataNode instanceof Sense) {
//			System.out.println("+++ new poshsense for "  + this.getName() + " " + dataNode.toString());
            SimpleSenseWidget poshSenseWidget =
                    new SimpleSenseWidget(getPoshScene(), (Sense) dataNode, this);

            // correct order when adding
            int index = 0;
            for (PoshWidget pw : this.getChildNodes()) {
                if (!(pw instanceof SimpleSenseWidget)) {
                    break;
                }
                index++;
            }

            this.getChildNodes().add(0/*index*/, poshSenseWidget);
            this.getPoshScene().addPoshWidget(poshSenseWidget, true);

        } else if (dataNode instanceof TriggeredAction) {
//			System.out.println("+++ new triggered action for "  + this.getName() + " " + dataNode.toString());
            addTriggeredActionWidgets((TriggeredAction) dataNode);
        } else {
//			System.out.println("+++ new SOMETHING for "  + this.getName() + " " + dataNode.toString() + " " + dataNode.getClass().getCanonicalName() );
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(CompetenceElement.caName)) {
            this.setHeadlineText((String) evt.getNewValue());
            this.doRepaint();
        }
    }

    @Override
    protected List<AbstractAcceptAction> getAcceptProviders() {
        List<AbstractAcceptAction> list = new LinkedList<AbstractAcceptAction>();

        list.add(new AcceptCPE2CPE(getDataNode()));
        list.add(new AcceptSense2CPE(getDataNode()));

        return list;
    }

    @Override
    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        sheet.put(set);

        try {
            Property nameProp = new PropertySupport.Reflection<String>(compAtom, String.class, "getElementName", "setElementName");
            Property retriesProp = new PropertySupport.Reflection<Integer>(compAtom, Integer.class, "getRetries", "setRetries");
            Property commentProp = new PropertySupport.Reflection<String>(compAtom, String.class, "getComment", "setComment");

            nameProp.setName(CompetenceElement.caName);
            retriesProp.setName(CompetenceElement.caRetries);
            commentProp.setName(CompetenceElement.caComment);

            nameProp.setDisplayName("Name of competence atom");
            retriesProp.setDisplayName("Number of retries");
            commentProp.setDisplayName("Comment");

            set.put(new Property[]{nameProp, retriesProp, commentProp});
        } catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace(ex);
        }
        return sheet;
    }
}
