package cz.cuni.pogamut.posh.palette;

import java.util.ArrayList;
import org.openide.nodes.Index;
import org.openide.nodes.Node;

/**
 * Children of the "Add POSH primitive" node in the palette.
 * @author Honza
 */
class GenericChildren extends Index.ArrayChildren {
	private PoshPaletteNode[] children = new PoshPaletteNode[] {
		new AddDriveActionNode(),
		new AddCompActionNode(),
		new AddTAActionNode(),
		new AddSenseActionNode(),
		new AddAPActionNode(),
                new AddGoalActionNode()
	};

	@Override
	protected java.util.List<Node> initCollection() {
		ArrayList<Node> list = new ArrayList<Node>();
		
		for (PoshPaletteNode child : children)
			list.add(child);
		
		return list;
	}
}