package cz.cuni.pogamut.posh.palette;

import cz.cuni.amis.pogamut.sposh.PoshTreeEvent;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import java.beans.PropertyChangeEvent;
import java.util.List;
import org.openide.nodes.Children;

/**
 * List of all competences in POSH plan. Updated when tree changes.
 * 
 * @author Honza
 */
public class CompChildren extends Children.SortedMap<Competence> implements PoshElementListener {

    @Override
    public void nodeChanged(PoshTreeEvent event, PoshElement child) {
        refresh(child.getRootNode());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        refresh(((PoshElement)evt.getSource()).getRootNode());
    }

    public void refresh(PoshPlan plan) {
        List<Competence> competences = plan.getCompetences();

        // remove all old actions in palette
        for (Competence comp : this.nodes.keySet().toArray(new Competence[0])) {
            remove(comp);
        }

        for (Competence competence : competences) {
            this.put(competence, new CompNode(competence));
        }

        refresh();
    }

}