/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.palette.external;

import cz.cuni.amis.pogamut.sposh.JavaBehaviour;
import cz.cuni.amis.pogamut.sposh.SPOSHAction;
import cz.cuni.amis.pogamut.sposh.SPOSHSense;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public final class ExternalBehaviourLoader {
    private static Logger log = Logger.getLogger(ExternalBehaviourLoader.class.getName());
    private DataObject dataObj;
    private Map<Class, BehaviourPrimitives> behaviourInfo = new HashMap<Class, BehaviourPrimitives>();

    public ExternalBehaviourLoader(DataObject dataObj) {
        this.dataObj = dataObj;
    }

    public synchronized Map<Class, BehaviourPrimitives> getBehaviourInfo() {
        if (this.behaviourInfo == null) {
            this.behaviourInfo = this.createBehaviourInfo();
        }
        return this.behaviourInfo;
    }

    public synchronized Map<Class, BehaviourPrimitives> createBehaviourInfo() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.dataObj.getPrimaryFile());
        if (project == null) {
            throw new IllegalStateException("File " + this.dataObj.getPrimaryFile().getNameExt() + " has no project owner.");
        }
        ClassPathProvider classPathResult = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        if (classPathResult == null) {
            throw new IllegalArgumentException("Project " + project.toString() + " has no ClassPathProvider.");
        }
        List<Class> behaviourClasses = this.getAllBehaviourClasses(classPathResult, "classpath/execute");
        for (Class behaviourClass : behaviourClasses) {
            this.behaviourInfo.put(behaviourClass, new BehaviourPrimitives(behaviourClass));
        }
        return Collections.unmodifiableMap(this.behaviourInfo);
    }

    protected synchronized void printInfo() {
        log.info("Behaviour info:");
        for (Map.Entry<Class, BehaviourPrimitives> entry : this.behaviourInfo.entrySet()) {
            log.info(entry.getKey().getCanonicalName() + ": " + entry.getValue());
        }
    }

    private List<Class> getAllBehaviourClasses(ClassPathProvider cpp, String type) {
        ClassPath classPath = cpp.findClassPath(this.dataObj.getPrimaryFile(), type);
        ArrayList<Class> behaviourClasses = new ArrayList<Class>();
        for (ClassPath.Entry entry : classPath.entries()) {
            try {
                behaviourClasses.add(this.getBehaviourClass(entry));
            }
            catch (IllegalArgumentException ex) {
                log.info(ex.getMessage());
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return behaviourClasses;
    }

    private Class getBehaviourClass(ClassPath.Entry entry) throws IOException, ClassNotFoundException {
        if (!entry.isValid()) {
            throw new IllegalArgumentException("Classpath entry (" + entry + ") is not valid. Skipping.");
        }
        if (!this.isJar(entry.getURL())) {
            throw new IllegalArgumentException("Classpath entry (" + entry + ") is not jar. Skipping.");
        }
        URL url = entry.getURL();
        URLClassLoader jarFileLoader = new URLClassLoader(new URL[]{url}, JavaBehaviour.class.getClassLoader());
        JarURLConnection jarUrl = (JarURLConnection)url.openConnection();
        Attributes mfAttributes = jarUrl.getMainAttributes();
        String behaviourClassName = mfAttributes.getValue(new Attributes.Name("X-BEHAVIOUR"));
        if (behaviourClassName == null) {
            throw new IllegalArgumentException("Classpath entry (" + entry + ") manifest doesn't contain X-BEHAVIOUR entry. Skipping.");
        }
        return jarFileLoader.loadClass(behaviourClassName);
    }

    private boolean isJar(URL url) {
        return "jar".equals(url.getProtocol());
    }

    public static final class BehaviourPrimitives {
        private final List<Method> actions;
        private final List<Method> senses;

        public BehaviourPrimitives(Class behaviourClass) {
            this.actions = this.getActions(behaviourClass);
            this.senses = this.getSenses(behaviourClass);
        }

        public BehaviourPrimitives(Collection<Method> actions, Collection<Method> senses) {
            this.actions = new ArrayList<Method>(actions);
            this.senses = new ArrayList<Method>(senses);
        }

        private List<Method> getActions(Class behaviourClass) {
            ArrayList<Method> result = new ArrayList<Method>();
            for (Method method : behaviourClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(SPOSHAction.class)) continue;
                result.add(method);
            }
            return result;
        }

        private List<Method> getSenses(Class behaviourClass) {
            ArrayList<Method> result = new ArrayList<Method>();
            for (Method method : behaviourClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(SPOSHSense.class)) continue;
                result.add(method);
            }
            return result;
        }

        public List<Method> getActions() {
            return this.actions;
        }

        public List<Method> getSenses() {
            return this.senses;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Actions:");
            for (Method action : this.getActions()) {
                sb.append(" ");
                sb.append(action.getName());
            }
            sb.append("; Senses");
            for (Method sense : this.getSenses()) {
                sb.append(" ");
                sb.append(sense.getName());
            }
            return sb.append(";").toString();
        }
    }
}

