/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.pogamut.posh.widget.menuactions;

import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.CompetencePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.ElementList;
import cz.cuni.amis.pogamut.sposh.elements.Goal;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.pogamut.posh.widget.kidview.AbstractMenuAction;
import java.awt.event.ActionEvent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

/**
 *
 * @author Honza
 */
public class AddComp2Plan extends AbstractMenuAction<PoshPlan> {

    public AddComp2Plan(PoshPlan plan) {
        super("Add competence node", plan);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String priorityName = getIdentifierFromDialog("Name of priority competence element");
            if (priorityName == null) {
                return;
            }

            String compName = getIdentifierFromDialog("Name of priority competence element");
            if (compName == null) {
                return;
            }

            CompetencePriorityElement priorityCompetence = new CompetencePriorityElement(new CompetenceElement(compName, new Sense("succeed"), "doNothing", null));
            Competence competence = new Competence(priorityName, null,
                    new Goal(new Sense("fail")),
                    new ElementList<CompetencePriorityElement>(priorityCompetence), null);

            dataNode.addCompetence(competence);
        } catch (ParseException ex) {
            NotifyDescriptor.Message error = new NotifyDescriptor.Message(ex.getMessage(), NotifyDescriptor.ERROR_MESSAGE);
            DialogDisplayer.getDefault().notify(error);
        }
    }
}

