package cz.cuni.pogamut.posh.widget.accept;

import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.CompetencePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.ElementList;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;

/**
 * Class for accepting dropped Sense to the SimpleCompetenceElementWidget.
 * Creates a new CE in CPE with action doNothing and is triggered with
 * passed sense.
 * @author Honza
 */
public class AcceptSense2CPE extends AbstractAcceptAction<CompetencePriorityElement> {

    public AcceptSense2CPE(CompetencePriorityElement dataNode) {
        super(Sense.dataFlavor, dataNode);
    }

    @Override
    protected void performAction(Transferable tr) throws UnsupportedFlavorException, IOException {
        Sense sense = (Sense) tr.getTransferData(dataFlavor);
        if (sense == null) {
            return;
        }

        List<CompetenceElement> elements = dataNode.getElements();

        if (elements.size() == 0) {
            ElementList<Sense> triggers = new ElementList<Sense>();
            triggers.add(sense);

            CompetenceElement cAtom = new CompetenceElement(
                    "competence atom",
                    triggers,
                    "doNothing", null, null);
            this.dataNode.addCompetenceElement(cAtom);
        } else if (elements.size() == 1) {
            elements.get(0).addUserTrigger(sense);
        } else {
            throw new IllegalStateException("CPE is supposed to have exactly one child, has " + dataNode.getElements().size());
        }
    }
}
