package cz.cuni.pogamut.posh.palette;

import java.util.Arrays;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

/**
 * Children of Palette root node.
 *
 * It has Generic|Comp|APs|Actions|Senses CategoryNode as children.
 * @author Honza
 */
public final class PaletteRootChildren extends Index.ArrayChildren {
	private GenericCategoryNode addNode;
	private CompCategoryNode competencesNode;
	private APsCategoryNode apsNode;
	private ActionsCategoryNode actionsNode;
	private SensesCategoryNode sensesNode;

        private Lookup lookup;

        PaletteRootChildren(Lookup lookup) {
            this.lookup = lookup;
        }
	
	@Override
	protected java.util.List<Node> initCollection() {
		Node[] list = new Node[] {
			addNode = new GenericCategoryNode("Add new"),
//			addNode = new GenericCategoryNode("Add new", new String[]{"Drive","Competence","Act", "Sense", "Action pattern"}),
			competencesNode = new CompCategoryNode(),
			apsNode = new APsCategoryNode(),
			actionsNode = new ActionsCategoryNode(lookup),
			sensesNode = new SensesCategoryNode(lookup)
		};
		
		return Arrays.asList(list);
	}

	/**
	 * Get node that has various add posh element as its children.
	 * @return Node that has add element as its children
	 */
	GenericCategoryNode getAddNode() {
		return addNode;
	}

	/**
	 * Get node that has all competence in its children
	 * @return node with all competence representative nodes as its children
	 */
	CompCategoryNode getCompetencesNode() {
		return competencesNode;
	}

	/**
	 * Get node that contains list of all APs.
	 * @return node with all of POSH plan APs as children
	 */
	APsCategoryNode getApsNode() {
		return apsNode;
	}

	/**
	 * Get node that has all triggered action existing in the plan as itch children.
	 * @return one node that is a child in this list of children.
	 */
	ActionsCategoryNode getActionsNode() {
		return actionsNode;
	}

	/**
	 * Get node that has all senses existing in the plan as itch children.
	 * @return one node that is a child in this list of children.
	 */
	SensesCategoryNode getSensesNode() {
		return sensesNode;
	}

}



