package cz.cuni.pogamut.posh.palette;

import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;

/**
 * Root node of palette that contains various actions and lists of POSH primitives
 * (competences, APs, actions, senses).
 * <p>
 * Used for editing of POSH plan.
 * 
 * @author Honza
 */
public class PaletteRoot extends AbstractNode {

	public PaletteRoot(Lookup lookup) {
		super(new PaletteRootChildren(lookup));
	}

	public PaletteRoot(Children children, Lookup lookup) {
		super(children, lookup);
	}

	/**
	 * Get children that contain all AP in POSH plan
	 * @return children of the node that containes all AP in the POSH plan
	 */
	public APsChildren getAPsChildren() {
		return this.getRootChildren().getApsNode().getAPsChildren();
	}

	/**
	 * Get children that contain all comptences in POSH plan
	 * @return children of the node that containes all competences in the POSH plan
	 */
	public CompChildren getComptencesChildren() {
		return this.getRootChildren().getCompetencesNode().getCompChildren();
	}

	/**
	 * Get children that contain all senses in POSH plan
	 * @return children of the node that containes all senses in the POSH plan
	 */
	public SensesChildren getSensesChildren() {
		return this.getRootChildren().getSensesNode().getSensesChildren();
	}

	/**
	 * Get children that contain all triggered actions in POSH plan
	 * @return children of the node that containes all triggered actions in the POSH plan
	 */
	public ActionsChildren getActionsChildren() {
		return this.getRootChildren().getActionsNode().getActionsChildren();
	}

	/**
	 * Get children of the PaletteRootNode, properly typed
	 * @return children of this node
	 */
	public PaletteRootChildren getRootChildren() {
		return (PaletteRootChildren) this.getChildren();
	}

}
