/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.sicstus;

import cz.cuni.amis.planning4j.ActionDescription;
import cz.cuni.amis.planning4j.IDomainProvider;
import cz.cuni.amis.planning4j.IPlanningResult;
import cz.cuni.amis.planning4j.IProblemProvider;
import cz.cuni.amis.planning4j.PlanningException;
import cz.cuni.amis.planning4j.PlanningIOException;
import cz.cuni.amis.planning4j.PlanningStatistics;
import cz.cuni.amis.planning4j.impl.PlanningResult;
import cz.cuni.amis.planning4j.pddl.PDDLAction;
import cz.cuni.amis.planning4j.pddl.PDDLDomain;
import cz.cuni.amis.planning4j.pddl.PDDLPredicate;
import cz.cuni.amis.planning4j.pddl.PDDLProblem;
import cz.cuni.amis.planning4j.pddl.PDDLSimpleAction;
import cz.cuni.amis.planning4j.sicstus.AbstractSicstusPlanner;
import cz.cuni.amis.planning4j.utils.PlanningUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.sics.jasper.Query;
import se.sics.jasper.SPException;
import se.sics.jasper.Term;

public class RelaxPlan
extends AbstractSicstusPlanner {
    private long timeout;
    boolean debug;
    public static final long DEFAULT_TIMEOUT = 300000L;
    List<String> indexedActions;
    List<String> indexedAtoms;
    Map<String, Integer> atomsToIndex;
    Map<String, Integer> actionsToIndex;
    protected static final String PLAN_VAR_NAME = "Plan";

    public RelaxPlan() {
        this(300000L);
    }

    public RelaxPlan(long timeout) {
        this(timeout, false);
    }

    public RelaxPlan(long timeout, boolean debug) {
        super(AbstractSicstusPlanner.class.getResourceAsStream("relaxplan.sav"));
        this.timeout = timeout;
        this.debug = debug;
    }

    @Override
    protected Query preparePrologQuery(IDomainProvider domainProvider, IProblemProvider problemProvider, Map variableMap) {
        try {
            File problemFile = this.writePrologProblemDefinition(domainProvider, problemProvider);
            prolog.query("['" + problemFile.getAbsolutePath().replace("\\", "/") + "'].", null);
            return prolog.openPrologQuery("plan(Plan," + this.timeout + ").", variableMap);
        }
        catch (IOException ex) {
            throw new PlanningIOException(ex);
        }
        catch (SPException ex) {
            throw new PlanningException("Prolog error", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new PlanningException("Unrecognized error", (Throwable)ex);
        }
    }

    @Override
    protected IPlanningResult parseResultFromBoundVariables(Map variableMap, String plannerOutput) {
        try {
            Term[] planTerms = ((Term)variableMap.get(PLAN_VAR_NAME)).toPrologTermArray();
            ArrayList<ActionDescription> actions = new ArrayList<ActionDescription>(planTerms.length);
            int time = 0;
            for (Term planElement : planTerms) {
                String actionName = PlanningUtils.normalizeIdentifier((String)this.indexedActions.get((int)planElement.getInteger() - 1));
                ActionDescription actionDescription = new ActionDescription();
                actionDescription.setName(actionName);
                actionDescription.setStartTime((double)time);
                actionDescription.setDuration(1.0);
                actions.add(actionDescription);
                ++time;
            }
            PlanningResult result = new PlanningResult(true, actions, new PlanningStatistics());
            return result;
        }
        catch (Exception ex) {
            throw new PlanningException("Prolog error.", (Throwable)ex);
        }
    }

    protected File writePrologProblemDefinition(IDomainProvider domainProvider, IProblemProvider problemProvider) throws PlanningException, IOException {
        File problemDefinitionTempFile = File.createTempFile("relaxPlan_problem_", ".pl");
        problemDefinitionTempFile.deleteOnExit();
        FileWriter problemWriter = new FileWriter(problemDefinitionTempFile);
        PDDLDomain domain = domainProvider.getDomainAsPDDL();
        if (domain == null) {
            throw new PlanningException("Given domain does not support getDomainAsPDDL()");
        }
        PDDLProblem problem = problemProvider.getProblemAsPDDL();
        if (problem == null) {
            throw new PlanningException("Given problem does not support getProblemAsPDDL()");
        }
        this.indexedAtoms = new ArrayList<String>(domain.getPredicates().size());
        this.atomsToIndex = new HashMap<String, Integer>(domain.getPredicates().size());
        for (PDDLPredicate predicate : domain.getPredicates()) {
            if (!predicate.getParameters().isEmpty()) {
                throw new PlanningException("Only ground predicates and actions are supported");
            }
            this.indexedAtoms.add(predicate.getName());
            int currentAtomIndex = this.indexedAtoms.size();
            this.atomsToIndex.put(predicate.getName(), currentAtomIndex);
        }
        this.indexedActions = new ArrayList<String>(domain.getActions().size());
        this.actionsToIndex = new HashMap<String, Integer>(domain.getActions().size());
        for (PDDLAction action : domain.getActions()) {
            if (!action.getParameters().isEmpty()) {
                throw new PlanningException("Only ground predicates and actions are supported");
            }
            if (!(action instanceof PDDLSimpleAction)) {
                throw new PlanningException("Only PDDLSimpleActions are currently supported");
            }
            PDDLSimpleAction simpleAction = (PDDLSimpleAction)action;
            if (!simpleAction.getNegativeEffects().isEmpty()) {
                throw new PlanningException("Negative effects are not supported");
            }
            this.indexedActions.add(action.getName());
            int currentActionIndex = this.indexedActions.size();
            this.actionsToIndex.put(action.getName(), currentActionIndex);
            for (String precondition : simpleAction.getPreconditionList()) {
                Integer preconditionIndex = this.atomsToIndex.get(precondition);
                if (preconditionIndex == null) {
                    throw new PlanningException("Precondition " + precondition + " for action " + action.getName() + " is not defined.");
                }
                problemWriter.write("p(" + currentActionIndex + "," + preconditionIndex + ").");
                if (this.debug) {
                    problemWriter.write("%% action: " + action.getName() + " prec: " + precondition);
                }
                problemWriter.write("\n");
            }
            for (String effect : simpleAction.getPositiveEffects()) {
                Integer effectIndex = this.atomsToIndex.get(effect);
                if (effectIndex == null) {
                    throw new PlanningException("Effect " + effect + " for action " + action.getName() + " is not defined.");
                }
                problemWriter.write("e(" + currentActionIndex + "," + effectIndex + ").");
                if (this.debug) {
                    problemWriter.write("%% action: " + action.getName() + " effect: " + effect);
                }
                problemWriter.write("\n");
            }
            problemWriter.write("c(" + currentActionIndex + ",1).\n");
        }
        problemWriter.write("d(" + this.indexedAtoms.size() + "," + this.indexedActions.size() + ").\n");
        for (String initialLiteral : problem.getInitialLiterals()) {
            Integer literalIndex = this.atomsToIndex.get(initialLiteral);
            if (literalIndex == null) {
                throw new PlanningException("Literal " + initialLiteral + " for initial state is not defined.");
            }
            problemWriter.write("i(" + literalIndex + ").");
            if (this.debug) {
                problemWriter.write("%% " + initialLiteral);
            }
            problemWriter.write("\n");
        }
        for (String goalLiteral : problem.getGoalConditions()) {
            Integer literalIndex = this.atomsToIndex.get(goalLiteral);
            if (literalIndex == null) {
                throw new PlanningException("Literal " + goalLiteral + " for initial state is not defined.");
            }
            problemWriter.write("g(" + literalIndex + ").");
            if (this.debug) {
                problemWriter.write("%% " + goalLiteral);
            }
            problemWriter.write("\n");
        }
        ((Writer)problemWriter).close();
        return problemDefinitionTempFile;
    }
}

