/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.sicstus;

import cz.cuni.amis.planning4j.IDomainProvider;
import cz.cuni.amis.planning4j.IPlanFuture;
import cz.cuni.amis.planning4j.IPlanningResult;
import cz.cuni.amis.planning4j.IProblemProvider;
import cz.cuni.amis.planning4j.PlanningException;
import cz.cuni.amis.planning4j.PlanningIOException;
import cz.cuni.amis.planning4j.impl.AbstractAsyncPlanner;
import cz.cuni.amis.planning4j.impl.PlanFuture;
import cz.cuni.amis.planning4j.impl.PlanningResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import se.sics.jasper.Jasper;
import se.sics.jasper.Prolog;
import se.sics.jasper.Query;

public abstract class AbstractSicstusPlanner
extends AbstractAsyncPlanner {
    protected static Prolog prolog = null;
    private static File plannerInputFile = null;
    private static final Object prologCreationMutex = new Object();

    private static File createTempFileFromStream(InputStream s) {
        try {
            File tempFile = File.createTempFile("Sicstus", ".sav");
            FileOutputStream output = new FileOutputStream(tempFile);
            IOUtils.copy((InputStream)s, (OutputStream)output);
            output.close();
            return tempFile;
        }
        catch (IOException ex) {
            throw new PlanningException("Error preparing save file");
        }
    }

    public AbstractSicstusPlanner(InputStream plannerInput) {
        this(AbstractSicstusPlanner.createTempFileFromStream(plannerInput));
        plannerInputFile.deleteOnExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractSicstusPlanner(File plannerInput) {
        Object object = prologCreationMutex;
        synchronized (object) {
            plannerInputFile = plannerInput;
            if (prolog == null) {
                try {
                    String bootPath = System.getProperty("sicstus.home");
                    if (bootPath == null) {
                        bootPath = System.getenv("SICSTUS_HOME");
                    }
                    prolog = Jasper.newProlog((String[])new String[0], (String)bootPath, (String)plannerInput.getAbsolutePath());
                    prolog.query("set_prolog_flag(redefine_warnings, off), set_prolog_flag(discontiguous_warnings, off).", null);
                }
                catch (Exception ex) {
                    throw new PlanningException("Could not initialize SICStus", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPlanFuture planAsync(IDomainProvider domainProvider, IProblemProvider problemProvider) {
        Query q;
        File tmpFileForOutput;
        HashMap variableMap = new HashMap();
        try {
            tmpFileForOutput = File.createTempFile("sicstus_plan_", "out");
            tmpFileForOutput.deleteOnExit();
        }
        catch (IOException ex) {
            throw new PlanningIOException("Could not create temp file to capture output", ex);
        }
        try {
            prolog.query("tell('" + tmpFileForOutput.getAbsolutePath().replace("\\", "/") + "').", null);
        }
        catch (Exception ex) {
            throw new PlanningException("Prolog output redirection failed: " + ex.getMessage(), (Throwable)ex);
        }
        Prolog prolog = AbstractSicstusPlanner.prolog;
        synchronized (prolog) {
            q = this.preparePrologQuery(domainProvider, problemProvider, variableMap);
        }
        SicstusPlanningFuture planningFuture = new SicstusPlanningFuture(q);
        SicstusPlanningProcess process = new SicstusPlanningProcess(planningFuture, q, variableMap, tmpFileForOutput);
        new Thread((Runnable)process, "SicstusPlanning").start();
        return planningFuture;
    }

    protected abstract Query preparePrologQuery(IDomainProvider var1, IProblemProvider var2, Map var3);

    protected abstract IPlanningResult parseResultFromBoundVariables(Map var1, String var2);

    protected class SicstusPlanningFuture
    extends PlanFuture<IPlanningResult> {
        private final Query prologQuery;

        public SicstusPlanningFuture(Query prologQuery) {
            this.prologQuery = prologQuery;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean cancelComputation(boolean mayInterruptIfRunning) {
            if (mayInterruptIfRunning) {
                try {
                    Prolog prolog = AbstractSicstusPlanner.prolog;
                    synchronized (prolog) {
                        this.prologQuery.close();
                    }
                }
                catch (Exception ex) {
                    throw new PlanningException("Error closing query", (Throwable)ex);
                }
                return true;
            }
            return super.cancelComputation(mayInterruptIfRunning);
        }
    }

    protected class SicstusPlanningProcess
    implements Runnable {
        private final PlanFuture planFuture;
        private final Query query;
        private Map variableMap;
        private File tmpFileForOutput;

        public SicstusPlanningProcess(PlanFuture planFuture, Query query, Map variableMap, File tmpFileForOutput) {
            this.planFuture = planFuture;
            this.query = query;
            this.variableMap = variableMap;
            this.tmpFileForOutput = tmpFileForOutput;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block14: {
                try {
                    boolean success;
                    PlanFuture planFuture = this.planFuture;
                    synchronized (planFuture) {
                        success = this.query.nextSolution();
                    }
                    prolog.query("flush_output,told.", null);
                    if (!success) {
                        planFuture = this.planFuture;
                        synchronized (planFuture) {
                            if (!this.planFuture.isCancelled()) {
                                this.planFuture.setResult((Object)PlanningResult.FAILED_RESULT);
                            }
                            break block14;
                        }
                    }
                    IPlanningResult result = AbstractSicstusPlanner.this.parseResultFromBoundVariables(this.variableMap, FileUtils.readFileToString((File)this.tmpFileForOutput));
                    PlanFuture planFuture2 = this.planFuture;
                    synchronized (planFuture2) {
                        if (!this.planFuture.isCancelled()) {
                            this.planFuture.setResult((Object)result);
                        }
                    }
                }
                catch (Exception ex) {
                    this.planFuture.computationException(ex);
                }
            }
        }
    }
}

