/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.util.regex.Pattern;

public class FileMarker {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private String prefix;
    private File directory;

    public FileMarker(String prefix, File directory) {
        this.prefix = prefix;
        this.directory = directory;
        if (this.directory.exists() && !this.directory.isDirectory()) {
            throw new RuntimeException("'directory' exists but it is not directory: " + directory.getAbsolutePath());
        }
    }

    public FileMarker(String prefix, String pathToDirectory) {
        this(prefix, new File(pathToDirectory));
    }

    public Pattern getMarkFileNamePattern() {
        return Pattern.compile("^" + this.prefix + "\\-.*\\.mark$");
    }

    public File getFileMark(String mark) {
        return new File(this.directory, this.prefix + "-" + mark + ".mark");
    }

    public File getFileMark(String mark, int index) {
        return new File(this.directory, this.prefix + "-" + mark + "." + index + ".mark");
    }

    protected boolean isExists(File markFile) {
        return markFile.exists() && markFile.isFile();
    }

    protected void touch(File markFile) {
        if (!this.directory.exists()) {
            this.directory.mkdirs();
        }
        if (markFile.exists()) {
            if (markFile.isFile()) {
                if (!markFile.delete()) {
                    throw new RuntimeException("Failed to touch the mark, could not delete old mark: " + markFile.getAbsolutePath());
                }
            } else {
                throw new RuntimeException("Cannot touch the mark, because it already exists and it is not file: " + markFile.getAbsolutePath());
            }
        }
        try {
            new FileOutputStream(markFile).close();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to touch the mark: " + markFile.getAbsolutePath(), e);
        }
    }

    public void remove(File markFile) {
        if (markFile.exists() && markFile.isFile() && !markFile.delete()) {
            throw new RuntimeException("Failed to delete the mark: " + markFile.getAbsolutePath());
        }
    }

    public boolean isExists(String mark) {
        File markFile = this.getFileMark(mark);
        return this.isExists(markFile);
    }

    public void touch(String mark) {
        File markFile = this.getFileMark(mark);
        this.touch(markFile);
    }

    public void remove(String mark) {
        File markFile = this.getFileMark(mark);
        this.remove(markFile);
    }

    public boolean isExists(String mark, int index) {
        File markFile = this.getFileMark(mark, index);
        return this.isExists(markFile);
    }

    public void touch(String mark, int index) {
        File markFile = this.getFileMark(mark, index);
        this.touch(markFile);
    }

    public void remove(String mark, int index) {
        File markFile = this.getFileMark(mark, index);
        this.remove(markFile);
    }

    public void removeAllMarks() {
        if (!this.directory.exists()) {
            return;
        }
        Pattern pattern = this.getMarkFileNamePattern();
        for (File file : this.directory.listFiles()) {
            String fileName = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(FILE_SEPARATOR) + 1);
            if (!pattern.matcher(fileName).matches() || file.delete()) continue;
            throw new RuntimeException("Failed to delete mark: " + file.getAbsolutePath());
        }
    }
}

