/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.pddl;

import cz.cuni.amis.planning4j.pddl.PDDLAction;
import cz.cuni.amis.planning4j.pddl.PDDLOperators;
import cz.cuni.amis.planning4j.pddl.PDDLParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PDDLSimpleAction
extends PDDLAction {
    private List<String> preconditionList;
    private List<String> positiveEffects;
    private List<String> negativeEffects;

    public PDDLSimpleAction(String name, PDDLParameter ... parameters) {
        super(name, parameters);
        this.init();
    }

    public PDDLSimpleAction(String name, List<PDDLParameter> parameters) {
        super(name, parameters);
        this.init();
    }

    public PDDLSimpleAction(String name) {
        super(name);
        this.init();
    }

    private void init() {
        this.preconditionList = new ArrayList<String>();
        this.positiveEffects = new ArrayList<String>();
        this.negativeEffects = new ArrayList<String>();
    }

    public List<String> getNegativeEffects() {
        return this.negativeEffects;
    }

    public void setNegativeEffects(List<String> negativeEffects) {
        this.negativeEffects = negativeEffects;
    }

    public void setNegativeEffects(String ... negativeEffects) {
        this.setNegativeEffects(new ArrayList<String>(Arrays.asList(negativeEffects)));
    }

    public void addNegativeEffect(String negativeEffect) {
        this.negativeEffects.add(negativeEffect);
    }

    public List<String> getPositiveEffects() {
        return this.positiveEffects;
    }

    public void setPositiveEffects(List<String> positiveEffects) {
        this.positiveEffects = positiveEffects;
    }

    public void setPositiveEffects(String ... positiveEffects) {
        this.setPositiveEffects(new ArrayList<String>(Arrays.asList(positiveEffects)));
    }

    public void addPositiveEffect(String positiveEffect) {
        this.positiveEffects.add(positiveEffect);
    }

    public List<String> getPreconditionList() {
        return this.preconditionList;
    }

    public void setPreconditionList(List<String> preconditionList) {
        this.preconditionList = preconditionList;
    }

    public void setPreconditionList(String ... preconditionList) {
        this.setPreconditionList(new ArrayList<String>(Arrays.asList(preconditionList)));
    }

    public void addPrecondition(String precondition) {
        this.preconditionList.add(precondition);
    }

    @Override
    public String getPreconditionAsString() {
        if (this.preconditionList == null || this.preconditionList.isEmpty()) {
            return null;
        }
        return PDDLOperators.makeAnd(this.preconditionList);
    }

    @Override
    public String getEffectAsString() {
        if (this.negativeEffects.isEmpty()) {
            if (this.positiveEffects.isEmpty()) {
                return "";
            }
            return PDDLOperators.makeAnd(this.positiveEffects);
        }
        ArrayList<String> negativeEffectsNegated = new ArrayList<String>(this.negativeEffects.size());
        for (String negEff : this.negativeEffects) {
            negativeEffectsNegated.add(PDDLOperators.makeNot(negEff));
        }
        String negativeEffExpression = PDDLOperators.makeAnd(negativeEffectsNegated);
        if (this.positiveEffects.isEmpty()) {
            return negativeEffExpression;
        }
        ArrayList<String> allEffects = new ArrayList<String>(this.positiveEffects);
        allEffects.add(negativeEffExpression);
        return PDDLOperators.makeAnd(allEffects);
    }
}

