/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.pddl;

import cz.cuni.amis.planning4j.pddl.PDDLObjectInstance;
import cz.cuni.amis.planning4j.pddl.PDDLOperators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PDDLProblem {
    String problemName;
    String domainName;
    List<PDDLObjectInstance> objects;
    List<String> initialLiterals;
    List<String> goalConditions;
    private boolean minimizeActionCosts = false;

    public PDDLProblem(String problemName, String domainName) {
        this.problemName = problemName;
        this.domainName = domainName;
        this.initialLiterals = Collections.EMPTY_LIST;
        this.objects = new ArrayList<PDDLObjectInstance>();
    }

    public void setGoalCondition(String goalCondition) {
        this.goalConditions = Collections.singletonList(goalCondition);
    }

    public void setInitialLiterals(List<String> initialLiterals) {
        this.initialLiterals = initialLiterals;
    }

    public void setInitialLiterals(String ... initialLiterals) {
        this.initialLiterals = Arrays.asList(initialLiterals);
    }

    public boolean isMinimizeActionCosts() {
        return this.minimizeActionCosts;
    }

    public void setMinimizeActionCosts(boolean minimizeActionCosts) {
        this.minimizeActionCosts = minimizeActionCosts;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getGoalConditionAsString() {
        if (this.goalConditions.isEmpty()) {
            return "true";
        }
        if (this.goalConditions.size() == 1) {
            return this.goalConditions.get(0);
        }
        return PDDLOperators.makeAnd(this.goalConditions);
    }

    public List<String> getInitialLiterals() {
        return this.initialLiterals;
    }

    public String getProblemName() {
        return this.problemName;
    }

    public List<String> getGoalConditions() {
        return this.goalConditions;
    }

    public void setGoalConditions(List<String> goalConditions) {
        this.goalConditions = goalConditions;
    }

    public List<PDDLObjectInstance> getObjects() {
        return this.objects;
    }

    public void addObject(PDDLObjectInstance object) {
        this.objects.add(object);
    }
}

