/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.pddl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PDDLOperators {
    public static String makeOperatorExpression(String operator, List<String> operands) {
        if (operands.isEmpty()) {
            throw new IllegalArgumentException("Operands cannot be emtpy");
        }
        StringBuilder sb = new StringBuilder(operator);
        for (String op : operands) {
            sb.append(" (").append(op).append(")");
        }
        return sb.toString();
    }

    public static String makeAnd(List<String> operands) {
        if (operands.size() == 1) {
            return operands.get(0);
        }
        return PDDLOperators.makeOperatorExpression("and", operands);
    }

    public static String makeAnd(String ... operands) {
        return PDDLOperators.makeAnd(Arrays.asList(operands));
    }

    public static String makeOr(List<String> operands) {
        if (operands.size() == 1) {
            return operands.get(0);
        }
        return PDDLOperators.makeOperatorExpression("or", operands);
    }

    public static String makeOr(String ... operands) {
        return PDDLOperators.makeOr(Arrays.asList(operands));
    }

    public static String makeNot(String operand) {
        return PDDLOperators.makeOperatorExpression("not", Collections.singletonList(operand));
    }
}

