/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.impl;

import cz.cuni.amis.planning4j.IAsyncPlanner;
import cz.cuni.amis.planning4j.IDomainProvider;
import cz.cuni.amis.planning4j.IPlanFuture;
import cz.cuni.amis.planning4j.IPlanningResult;
import cz.cuni.amis.planning4j.IProblemProvider;
import cz.cuni.amis.planning4j.PlanningException;
import cz.cuni.amis.planning4j.impl.PlanFuture;

public abstract class AbstractAsyncPlanner<DOMAIN_TYPE extends IDomainProvider, PROBLEM_TYPE extends IProblemProvider>
implements IAsyncPlanner<DOMAIN_TYPE, PROBLEM_TYPE> {
    private Class<DOMAIN_TYPE> domainClass;
    private Class<PROBLEM_TYPE> problemClass;

    public AbstractAsyncPlanner(Class<DOMAIN_TYPE> domainClass, Class<PROBLEM_TYPE> problemClass) {
        this.domainClass = domainClass;
        this.problemClass = problemClass;
    }

    @Override
    public Class<DOMAIN_TYPE> getDomainClass() {
        return this.domainClass;
    }

    @Override
    public Class<PROBLEM_TYPE> getProblemClass() {
        return this.problemClass;
    }

    @Override
    public IPlanningResult plan(DOMAIN_TYPE domainProvider, PROBLEM_TYPE problemProvider) {
        IPlanFuture future = this.planAsync(domainProvider, problemProvider);
        try {
            Exception except;
            Object result = future.get();
            if (future instanceof PlanFuture && (except = ((PlanFuture)future).getException()) != null) {
                throw except;
            }
            return result;
        }
        catch (PlanningException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PlanningException("Asynchronuous plan computation failed: " + ex.getMessage(), ex);
        }
    }
}

