/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.impl;

import cz.cuni.amis.planning4j.IAsyncPlanner;
import cz.cuni.amis.planning4j.IDomainProvider;
import cz.cuni.amis.planning4j.IPlanFuture;
import cz.cuni.amis.planning4j.IPlanner;
import cz.cuni.amis.planning4j.IPlanningResult;
import cz.cuni.amis.planning4j.IProblemProvider;
import cz.cuni.amis.planning4j.impl.PlanFuture;

public class AsyncPlannerWrapper<DOMAIN_TYPE extends IDomainProvider, PROBLEM_TYPE extends IProblemProvider>
implements IAsyncPlanner<DOMAIN_TYPE, PROBLEM_TYPE> {
    IPlanner<DOMAIN_TYPE, PROBLEM_TYPE> planner;

    public AsyncPlannerWrapper(IPlanner<DOMAIN_TYPE, PROBLEM_TYPE> planner) {
        this.planner = planner;
    }

    @Override
    public Class<DOMAIN_TYPE> getDomainClass() {
        return this.planner.getDomainClass();
    }

    @Override
    public Class<PROBLEM_TYPE> getProblemClass() {
        return this.planner.getProblemClass();
    }

    @Override
    public IPlanningResult plan(DOMAIN_TYPE domainProvider, PROBLEM_TYPE problemProvider) {
        return this.planner.plan(domainProvider, problemProvider);
    }

    @Override
    public IPlanFuture planAsync(DOMAIN_TYPE domainProvider, PROBLEM_TYPE problemProvider) {
        PlanFuture future = new PlanFuture();
        PlanningOperation operation = new PlanningOperation(this, future, domainProvider, problemProvider);
        new Thread((Runnable)operation, "AsyncPlanningWrapper").start();
        return future;
    }

    private static class PlanningOperation
    implements Runnable {
        private PlanFuture future;
        private DOMAIN_TYPE domainProvider;
        private PROBLEM_TYPE problemProvider;
        final /* synthetic */ AsyncPlannerWrapper this$0;

        public PlanningOperation(PlanFuture future, DOMAIN_TYPE domainProvider, PROBLEM_TYPE problemProvider) {
            this.this$0 = var1_1;
            this.future = future;
            this.domainProvider = domainProvider;
            this.problemProvider = problemProvider;
        }

        @Override
        public void run() {
            try {
                this.future.setResult(this.this$0.planner.plan(this.domainProvider, this.problemProvider));
            }
            catch (Exception ex) {
                this.future.computationException(ex);
            }
        }
    }
}

