/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.translators.problem;

import cz.cuni.amis.planning4j.IPDDLObjectProblemProvider;
import cz.cuni.amis.planning4j.IPDDLWriterProblemProvider;
import cz.cuni.amis.planning4j.impl.AbstractProblemTranslator;
import cz.cuni.amis.planning4j.pddl.PDDLProblem;
import java.io.IOException;
import java.io.Writer;

public class PDDLObjectToWriterProblemTranslator
extends AbstractProblemTranslator<IPDDLObjectProblemProvider, IPDDLWriterProblemProvider> {
    public PDDLObjectToWriterProblemTranslator() {
        super(IPDDLObjectProblemProvider.class, IPDDLWriterProblemProvider.class);
    }

    @Override
    public IPDDLWriterProblemProvider translateProblem(IPDDLObjectProblemProvider problem) {
        return new TranslatedProblemProvider(problem);
    }

    private class TranslatedProblemProvider
    implements IPDDLWriterProblemProvider {
        private IPDDLObjectProblemProvider problemProvider;

        public TranslatedProblemProvider(IPDDLObjectProblemProvider problemProvider) {
            this.problemProvider = problemProvider;
        }

        @Override
        public void writeProblem(Writer writer) throws IOException {
            writer.write("(define (problem " + this.getProblem().getProblemName() + ") (:domain " + this.getProblem().getDomainName() + ")\n");
            if (!this.getProblem().getInitialLiterals().isEmpty()) {
                writer.write("\t(:init \n");
                for (String literal : this.getProblem().getInitialLiterals()) {
                    writer.write("\t\t(" + literal + ")\n");
                }
                writer.write("\t)\n");
            }
            writer.write("\t(:goal (" + this.getProblem().getGoalConditionAsString() + "))\n");
            writer.write(")\n");
        }

        protected PDDLProblem getProblem() {
            return this.problemProvider.getPDDLProblem();
        }
    }
}

