/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.translators.domain;

import cz.cuni.amis.planning4j.IPDDLObjectDomainProvider;
import cz.cuni.amis.planning4j.IPDDLWriterDomainProvider;
import cz.cuni.amis.planning4j.impl.AbstractDomainTranslator;
import cz.cuni.amis.planning4j.pddl.PDDLAction;
import cz.cuni.amis.planning4j.pddl.PDDLConstant;
import cz.cuni.amis.planning4j.pddl.PDDLDomain;
import cz.cuni.amis.planning4j.pddl.PDDLParameter;
import cz.cuni.amis.planning4j.pddl.PDDLPredicate;
import cz.cuni.amis.planning4j.pddl.PDDLRequirement;
import cz.cuni.amis.planning4j.pddl.PDDLType;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class PDDLObjectToWriterDomainTranslator
extends AbstractDomainTranslator<IPDDLObjectDomainProvider, IPDDLWriterDomainProvider> {
    public PDDLObjectToWriterDomainTranslator() {
        super(IPDDLObjectDomainProvider.class, IPDDLWriterDomainProvider.class);
    }

    @Override
    public IPDDLWriterDomainProvider translateDomain(IPDDLObjectDomainProvider domain) {
        return new TranslatedDomainProvider(domain);
    }

    private class TranslatedDomainProvider
    implements IPDDLWriterDomainProvider {
        private IPDDLObjectDomainProvider domainProvider;

        public TranslatedDomainProvider(IPDDLObjectDomainProvider domainProvider) {
            this.domainProvider = domainProvider;
        }

        protected void writeRequirements(Writer writer) throws IOException {
            writer.write("\t(:requirements");
            for (PDDLRequirement req : this.getDomain().getRequirements()) {
                writer.write(" :" + req.getPddlName());
            }
            writer.write(")\n");
        }

        protected PDDLDomain getDomain() {
            return this.domainProvider.getPDDLDomain();
        }

        protected void writeOneType(Writer writer, PDDLType type) throws IOException {
            if (type.getAncestor() == null) {
                throw new NullPointerException("User defined types must have a non-null ancestor");
            }
            writer.write(" " + type.getTypeName() + " - " + type.getAncestor().getTypeName());
        }

        protected void writeTypes(Writer writer) throws IOException {
            writer.write("\t(:types ");
            for (PDDLType type : this.getDomain().getTypes()) {
                this.writeOneType(writer, type);
            }
            writer.write(")\n");
        }

        protected void writeOneConstant(Writer writer, PDDLConstant constant) throws IOException {
            writer.write("\t\t(" + constant.getStringForPDDL() + ")\n");
        }

        protected void writeConstants(Writer writer) throws IOException {
            writer.write("\t(:constants \n");
            for (PDDLConstant constant : this.getDomain().getConstants()) {
                this.writeOneConstant(writer, constant);
            }
            writer.write("\t)\n");
        }

        protected void writeParameters(Writer writer, List<PDDLParameter> parameters) throws IOException {
            for (PDDLParameter parameter : parameters) {
                writer.write(" " + parameter.getStringForPDDL());
            }
        }

        protected void writeOnePredicate(Writer writer, PDDLPredicate predicate) throws IOException {
            writer.write("\t\t(" + predicate.getName());
            this.writeParameters(writer, predicate.getParameters());
            writer.write(")\n");
        }

        protected void writePredicates(Writer writer) throws IOException {
            writer.write("\t(:predicates \n");
            for (PDDLPredicate predicate : this.getDomain().getPredicates()) {
                this.writeOnePredicate(writer, predicate);
            }
            writer.write("\t)\n");
        }

        protected void writeOneAction(Writer writer, PDDLAction action) throws IOException {
            writer.write("\t(:action " + action.getName() + "\n");
            List<PDDLParameter> parameters = action.getParameters();
            writer.write("\t\t:parameters (");
            this.writeParameters(writer, parameters);
            writer.write(")\n");
            String precondition = action.getPreconditionAsString();
            if (precondition != null && !precondition.isEmpty()) {
                writer.write("\t\t:precondition (" + precondition + ")\n");
            }
            writer.write("\t\t:effect (" + action.getEffectAsString() + ")\n");
            writer.write("\t)\n");
        }

        protected void writeActions(Writer writer) throws IOException {
            for (PDDLAction action : this.getDomain().getActions()) {
                this.writeOneAction(writer, action);
            }
        }

        @Override
        public void writeDomain(Writer writer) throws IOException {
            writer.write("(define (domain " + this.getDomain().getDomainName() + ")\n");
            this.writeRequirements(writer);
            if (!this.getDomain().getTypes().isEmpty()) {
                this.writeTypes(writer);
            }
            if (!this.getDomain().getConstants().isEmpty()) {
                this.writeConstants(writer);
            }
            if (!this.getDomain().getPredicates().isEmpty()) {
                this.writePredicates(writer);
            }
            if (!this.getDomain().getActions().isEmpty()) {
                this.writeActions(writer);
            }
            writer.write(")");
        }
    }
}

