/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning.javaaiplanningapi;

import cz.cuni.amis.planning4j.ActionDescription;
import cz.cuni.amis.planning4j.IDomainProvider;
import cz.cuni.amis.planning4j.IPlanner;
import cz.cuni.amis.planning4j.IPlanningResult;
import cz.cuni.amis.planning4j.IProblemProvider;
import cz.cuni.amis.planning4j.impl.PDDLObjectDomainProvider;
import cz.cuni.amis.planning4j.impl.PDDLObjectProblemProvider;
import cz.cuni.amis.planning4j.pddl.PDDLAction;
import cz.cuni.amis.planning4j.pddl.PDDLConstant;
import cz.cuni.amis.planning4j.pddl.PDDLDomain;
import cz.cuni.amis.planning4j.pddl.PDDLParameter;
import cz.cuni.amis.planning4j.pddl.PDDLPredicate;
import cz.cuni.amis.planning4j.pddl.PDDLProblem;
import cz.cuni.amis.planning4j.pddl.PDDLRequirement;
import cz.cuni.amis.planning4j.pddl.PDDLSimpleAction;
import cz.cuni.amis.planning4j.pddl.PDDLType;
import cz.cuni.amis.planning4j.utils.Planning4JUtils;
import java.util.EnumSet;
import org.junit.Assert;

public class PlannerTestUtils {
    public static void simpleDomainTest(IPlanner planner, boolean negativeEffects) {
        PDDLDomain domain = new PDDLDomain("test", EnumSet.of(PDDLRequirement.STRIPS));
        domain.addPredicate(new PDDLPredicate("at_loc1"));
        domain.addPredicate(new PDDLPredicate("at_loc2"));
        PDDLSimpleAction moveAction = new PDDLSimpleAction("move");
        moveAction.setPreconditionList(new String[]{"at_loc1"});
        moveAction.setPositiveEffects(new String[]{"at_loc2"});
        if (negativeEffects) {
            moveAction.setNegativeEffects(new String[]{"at_loc1"});
        }
        domain.addAction((PDDLAction)moveAction);
        PDDLProblem problem = new PDDLProblem("problem_1", "test");
        problem.setInitialLiterals(new String[]{"at_loc1"});
        problem.setGoalCondition("at_loc2");
        PDDLObjectDomainProvider domainProvider = new PDDLObjectDomainProvider(domain);
        PDDLObjectProblemProvider problemProvider = new PDDLObjectProblemProvider(problem);
        IPlanningResult result = Planning4JUtils.plan((IPlanner)planner, (IDomainProvider)domainProvider, (IProblemProvider)problemProvider);
        if (!result.isSuccess()) {
            Assert.fail((String)"No solution found.");
        } else {
            Assert.assertTrue((result.getPlan().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ActionDescription)result.getPlan().get(0)).getName().equalsIgnoreCase("move"));
        }
    }

    public static void variableDomainTest(IPlanner planner, boolean negativeEffects) {
        PDDLDomain domain = new PDDLDomain("test", EnumSet.of(PDDLRequirement.STRIPS));
        PDDLType locationType = new PDDLType("location", PDDLType.OBJECT_TYPE);
        domain.addType(locationType);
        domain.addPredicate(new PDDLPredicate("at", new PDDLParameter[]{new PDDLParameter("loc", locationType)}));
        domain.addConstant(new PDDLConstant("loc1", locationType));
        domain.addConstant(new PDDLConstant("loc2", locationType));
        PDDLSimpleAction moveAction = new PDDLSimpleAction("move", new PDDLParameter[]{new PDDLParameter("l1", locationType), new PDDLParameter("l2", locationType)});
        moveAction.setPreconditionList(new String[]{"at(l1)"});
        moveAction.setPositiveEffects(new String[]{"at(l2)"});
        if (negativeEffects) {
            moveAction.setNegativeEffects(new String[]{"at(l1)"});
        }
        domain.addAction((PDDLAction)moveAction);
        PDDLProblem problem = new PDDLProblem("problem_1", "test");
        problem.setInitialLiterals(new String[]{"at(loc1)"});
        problem.setGoalCondition("at(loc2)");
        PDDLObjectDomainProvider domainProvider = new PDDLObjectDomainProvider(domain);
        PDDLObjectProblemProvider problemProvider = new PDDLObjectProblemProvider(problem);
        IPlanningResult result = Planning4JUtils.plan((IPlanner)planner, (IDomainProvider)domainProvider, (IProblemProvider)problemProvider);
        if (!result.isSuccess()) {
            Assert.fail((String)"No solution found.");
        } else {
            Assert.assertTrue((result.getPlan().size() == 1 ? 1 : 0) != 0);
            ActionDescription firstAction = (ActionDescription)result.getPlan().get(0);
            Assert.assertTrue((boolean)firstAction.getName().equalsIgnoreCase("move"));
            Assert.assertTrue((firstAction.getParameters().size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((String)firstAction.getParameters().get(0)).equalsIgnoreCase("loc1"));
            Assert.assertTrue((boolean)((String)firstAction.getParameters().get(0)).equalsIgnoreCase("loc2"));
        }
    }
}

