/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.netbeans.publicpkgs;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import cz.cuni.amis.netbeans.publicpkgs.IncludeDir;
import cz.cuni.amis.utils.Const;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="NetBeansPublicPackages")
public class NetBeansPublicPackagesConfig {
    @XStreamImplicit(itemFieldName="excludeDir")
    private List<String> excludeDirs = new ArrayList<String>();
    @XStreamImplicit(itemFieldName="include")
    private List<IncludeDir> dirs = new ArrayList<IncludeDir>();
    @XStreamAlias(value="targetPom")
    private String targetPom;
    @XStreamImplicit(itemFieldName="packagePrefix")
    private List<String> packagePrefixes;

    public static NetBeansPublicPackagesConfig loadXML(File xmlFile) {
        FileReader reader;
        if (xmlFile == null) {
            throw new IllegalArgumentException("'xmlFile' can't be null!");
        }
        try {
            reader = new FileReader(xmlFile);
        }
        catch (FileNotFoundException e1) {
            throw new RuntimeException("File " + xmlFile.getAbsolutePath() + " not found: " + e1.getMessage(), e1);
        }
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.autodetectAnnotations(true);
        xstream.alias(NetBeansPublicPackagesConfig.class.getAnnotation(XStreamAlias.class).value(), NetBeansPublicPackagesConfig.class);
        Object obj = xstream.fromXML((Reader)reader);
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (obj == null || !(obj instanceof NetBeansPublicPackagesConfig)) {
            throw new RuntimeException("file " + xmlFile.getAbsolutePath() + " doesn't contain a xml with RewriteFilesConfig");
        }
        return (NetBeansPublicPackagesConfig)obj;
    }

    public NetBeansPublicPackagesConfig readResolve() {
        if (this.excludeDirs == null) {
            this.excludeDirs = new ArrayList<String>();
        }
        if (this.dirs == null) {
            this.dirs = new ArrayList<IncludeDir>();
        }
        for (IncludeDir dir : this.dirs) {
            if (dir.getExcludeDirs() == null) {
                dir.setExcludeDirs(this.excludeDirs);
                continue;
            }
            dir.getExcludeDirs().addAll(this.excludeDirs);
        }
        if (this.packagePrefixes == null) {
            this.packagePrefixes = new ArrayList<String>();
        }
        return this;
    }

    public void initialize() {
        if (this.packagePrefixes.size() == 0) {
            this.packagePrefixes.add("");
        }
    }

    public List<String> getExcludeDirs() {
        return this.excludeDirs;
    }

    public void setExcludeDirs(List<String> excludeDirs) {
        this.excludeDirs = excludeDirs;
    }

    public List<IncludeDir> getDirs() {
        return this.dirs;
    }

    public void setDirs(List<IncludeDir> dirs) {
        this.dirs = dirs;
    }

    public String getTargetPom() {
        return this.targetPom;
    }

    public void setTargetPom(String targetPom) {
        this.targetPom = targetPom;
    }

    public List<String> getPackagePrefixes() {
        return this.packagePrefixes;
    }

    public void setPackagePrefixes(List<String> packagePrefixes) {
        this.packagePrefixes = packagePrefixes;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(prefix) + "PublicPackagesConfig[");
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "  targetPom = " + this.targetPom);
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "  replace packge with prefixes = ");
        if (this.packagePrefixes == null || this.packagePrefixes.size() == 0) {
            sb.append(String.valueOf(Const.NEW_LINE) + prefix + "    <everything>");
        } else {
            for (String pkg : this.packagePrefixes) {
                sb.append(String.valueOf(Const.NEW_LINE) + prefix + "    " + pkg);
            }
        }
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "  excludeDirs =");
        if (this.excludeDirs == null || this.excludeDirs.size() == 0) {
            sb.append(" <none>");
        } else {
            for (String excludeDir : this.excludeDirs) {
                sb.append(String.valueOf(Const.NEW_LINE) + prefix + "    " + excludeDir);
            }
        }
        for (IncludeDir dir : this.dirs) {
            sb.append(String.valueOf(Const.NEW_LINE) + dir.toString("Dir", String.valueOf(prefix) + "  "));
        }
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "]");
        return sb.toString();
    }
}

