/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.netbeans.publicpkgs;

import cz.cuni.amis.netbeans.publicpkgs.IncludeDir;
import cz.cuni.amis.netbeans.publicpkgs.NetBeansPublicPackagesConfig;
import cz.cuni.amis.utils.Const;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.FilePath;
import cz.cuni.amis.utils.simple_logging.SimpleLogging;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class NetBeansPublicPackages {
    public static final Pattern PUBLIC_PACKAGES_BEGIN = Pattern.compile("(\\s*)\\<\\s*publicPackages\\s*\\>");
    public static final Pattern PUBLIC_PACKAGES_END = Pattern.compile("\\<\\s*\\/\\s*publicPackages\\s*\\>");
    public static final Pattern PUBLIC_PACKAGE = Pattern.compile("\\<\\s*publicPackage\\s*\\>([^<]*)\\<\\s*\\/\\s*publicPackage\\s*\\>");
    private NetBeansPublicPackagesConfig config;
    private Logger log;
    private boolean failure = false;
    String pomBegin;
    String pomEnd;
    String packagesPrefix = "";
    List<String> pomPublicPackages = new ArrayList<String>();

    public NetBeansPublicPackages(NetBeansPublicPackagesConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("'config' can't be null!");
        }
        this.config = config;
    }

    public NetBeansPublicPackages(File xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException("'xmlFile' can't be null!");
        }
        this.config = NetBeansPublicPackagesConfig.loadXML(xmlFile);
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    private boolean parsePublicPackages(File targetPom) {
        String pom;
        this.logInfo("Reading pom.xml from: " + targetPom.getAbsolutePath());
        try {
            pom = FileUtils.readFileToString((File)targetPom);
        }
        catch (IOException e) {
            this.logSevere(ExceptionToString.process((String)("Could not read " + targetPom.getAbsolutePath()), (Throwable)e));
            return false;
        }
        Matcher m = PUBLIC_PACKAGES_BEGIN.matcher(pom);
        if (!m.find()) {
            this.logSevere("<publicPackages> not found using pattern: " + PUBLIC_PACKAGES_BEGIN.pattern());
            return false;
        }
        this.packagesPrefix = m.group(1);
        if (this.packagesPrefix.startsWith(Const.NEW_LINE)) {
            this.packagesPrefix = this.packagesPrefix.substring(2);
        }
        this.pomBegin = pom.substring(0, m.start());
        String pomRest = pom.substring(m.start());
        if (!(m = PUBLIC_PACKAGES_END.matcher(pomRest)).find()) {
            this.logSevere("</publicPackages> not found using pattern: " + PUBLIC_PACKAGES_END.pattern());
        }
        this.pomEnd = pom.substring(this.pomBegin.length() + m.end());
        String pomPkgs = pomRest.substring(0, m.end());
        this.logInfo("Parsed <publicPackages> section:" + Const.NEW_LINE + pomPkgs);
        this.logInfo("Locating respective <publicPackage> decalarations using pattern: " + PUBLIC_PACKAGE.pattern());
        m = PUBLIC_PACKAGE.matcher(pomPkgs);
        while (m.find()) {
            String pkg = m.group(1).trim();
            if (!pkg.endsWith(".*")) {
                pkg = String.valueOf(pkg) + ".*";
            }
            this.logInfo("Located: " + pkg);
            boolean match = false;
            for (String packagePrefix : this.config.getPackagePrefixes()) {
                if (!pkg.startsWith(packagePrefix)) continue;
                this.logInfo("Matches package prefix (will be replaced): '" + packagePrefix + "'");
                match = true;
                break;
            }
            if (match) continue;
            this.logInfo("Does not match any package prefix, will be included in the result.");
            this.pomPublicPackages.add(pkg);
        }
        return true;
    }

    public synchronized boolean rewrite() {
        this.failure = false;
        this.logInfo("=================================================");
        this.logInfo("Configuration: " + Const.NEW_LINE + this.config.toString());
        this.logInfo("=================================================");
        this.logInfo("Initializing...");
        this.logInfo("-------------------------------------------------");
        this.config.initialize();
        if (this.config.getTargetPom() == null) {
            this.logSevere("config.getTargetPom() is null!");
            this.logSevere("FAILURE!");
            return false;
        }
        File targetPom = new File(this.config.getTargetPom());
        if (!targetPom.isFile() || !targetPom.exists()) {
            this.logSevere("Target pom is not a valid file, path: " + targetPom.getAbsolutePath());
            this.logSevere("FAILURE!");
            return false;
        }
        if (!this.parsePublicPackages(targetPom)) {
            this.logSevere("FAILURE!");
            return false;
        }
        this.logInfo("POM PACKAGES: " + this.pomPublicPackages.size());
        ArrayList<String> pkgs = new ArrayList<String>();
        for (IncludeDir inc : this.config.getDirs()) {
            this.logInfo("Crawling:" + Const.NEW_LINE + inc.toString("IncludeDir", " "));
            inc.initialize();
            if (inc.getDir() == null) {
                this.logSevere("Invalid directory: null");
                return false;
            }
            if (!inc.getDir().isDirectory() || !inc.getDir().exists()) {
                this.logSevere("Invalid directory: " + inc.getDir().getAbsolutePath());
                return false;
            }
            List<File> files = inc.getDirectoryWalker().walk(inc.getDir());
            this.logInfo("Found:");
            String prefix = FilePath.makeUniform((String)inc.getDir().getAbsolutePath());
            for (File file : files) {
                String path = FilePath.makeUniform((String)file.getAbsolutePath());
                if ((path = path.substring(prefix.length()).trim()).length() == 0) continue;
                this.logInfo("  Dir: " + path);
                String pkg = path.replaceAll("\\/", ".");
                pkg = pkg.endsWith(".") ? String.valueOf(pkg) + "*" : String.valueOf(pkg) + ".*";
                pkg = pkg.replaceAll("\\.\\.", ".");
                if (pkg.startsWith(".")) {
                    pkg = pkg.substring(1);
                }
                this.logInfo("  Pkg: " + pkg);
                pkgs.add(pkg);
            }
        }
        int allPak = pkgs.size() + this.pomPublicPackages.size();
        this.logInfo("FOUND PACKAGES: " + pkgs.size());
        this.logInfo("POM+FOUND PACKAGES: " + allPak);
        pkgs.addAll(this.pomPublicPackages);
        this.logInfo("Removing duplicities...");
        Collections.sort(pkgs);
        int i = 1;
        while (i < pkgs.size()) {
            if (((String)pkgs.get(i)).equals(pkgs.get(i - 1))) {
                pkgs.remove(i);
                continue;
            }
            ++i;
        }
        this.logInfo("TOTAL PACKAGES: " + pkgs.size());
        String result = String.valueOf(Const.NEW_LINE) + this.packagesPrefix + "<publicPackages>";
        for (String newPkg : pkgs) {
            result = String.valueOf(result) + Const.NEW_LINE + this.packagesPrefix + "    <publicPackage>" + newPkg + "</publicPackage>";
        }
        result = String.valueOf(result) + Const.NEW_LINE + this.packagesPrefix + "</publicPackages>";
        this.logInfo("Combined public packages:" + Const.NEW_LINE + result);
        String pom = String.valueOf(this.pomBegin) + result + this.pomEnd;
        this.logInfo("Rewriting " + targetPom.getAbsolutePath() + " ...");
        try {
            FileUtils.writeStringToFile((File)targetPom, (String)pom);
        }
        catch (IOException e) {
            this.logSevere(ExceptionToString.process((String)("Failed to rewrite " + targetPom.getAbsolutePath()), (Throwable)e));
            return false;
        }
        this.logInfo("FINISHED!");
        return true;
    }

    protected void logInfo(String msg) {
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(msg);
        }
    }

    protected void logWarning(String msg) {
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning(msg);
        }
    }

    protected void logSevere(String msg) {
        if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
            this.log.severe(msg);
        }
    }

    protected static void example(Logger log) {
        log.info("<NetBeansPublicPackages>" + Const.NEW_LINE + Const.NEW_LINE + "    <targetPom>Main/PogamutNetbeansSuiteBase/PogamutNbBase/pom.xml</targetPom>" + Const.NEW_LINE + Const.NEW_LINE + "    <!-- THESE PACKAGES WILL BE REMOVED FROM NetBeansModule pom.xml -->" + Const.NEW_LINE + "    <packagePrefix>cz.cuni.amis.base</packagePrefix>" + Const.NEW_LINE + "    <packagePrefix>cz.cuni.amis.utils</packagePrefix>" + Const.NEW_LINE + Const.NEW_LINE + "    <!-- GLOBAL DEFINITIONS THAT APPLIED TO ALL <include> TAGS -->" + Const.NEW_LINE + "    <excludeDir>.svn</excludeDir>      <!-- WILDCARDS NOT ALLOWED, RELATIVE PATH THAT IS BLOCKED == **/path/defined/in/exclude/dir -->" + Const.NEW_LINE + "    <excludeDir>.cvs</excludeDir>      <!-- WILDCARDS NOT ALLOWED, RELATIVE PATH THAT IS BLOCKED == **/path/defined/in/exclude/dir -->" + Const.NEW_LINE + Const.NEW_LINE + "    <!-- FOLLOWING DIRECTORIES WILL BE INTERPRETED AS JAVA-SOURCES DIRs CONTAINING PACKAGES THAT SHOULD BE ALL BE PUBLIC  -->" + Const.NEW_LINE + "    <!-- DEFINES DIRESTORIES TO WALK THROUGH, MAY ADD ADDITIONAL EXCLUDEs -->" + Const.NEW_LINE + "    <include dir=\"Main/PogamutBase/src/main/java\" />" + Const.NEW_LINE + "    <!-- excludeDir are inherited here -->" + Const.NEW_LINE + Const.NEW_LINE + "    <include dir=\"Utils/AmisUtils/src/main/java\">" + Const.NEW_LINE + "        <!-- INCLUDES ALL *.java BUT SomeFile.java FILES -->" + Const.NEW_LINE + "        <excludeDir>some/dir</excludeDir>" + Const.NEW_LINE + "    </include>" + Const.NEW_LINE + Const.NEW_LINE + "</NetBeansPublicPackages>");
    }

    public static void main(String[] args) {
        NetBeansPublicPackages publicPackages;
        String definition = "NetBeansPublicPackages.xml";
        if (args.length > 0 && (definition = args[0]) == null) {
            definition = "NetBeansPublicPackages.xml";
        }
        SimpleLogging.initLogging();
        Logger log = Logger.getAnonymousLogger();
        log.info("---[[ PUBLIC PACKAGES ]]---");
        log.info("Loading definition from xml file: " + definition + " --> " + new File(definition).getAbsoluteFile());
        File file = new File(definition);
        if (!file.exists() || !file.isFile()) {
            log.severe("FAILED! Definition file not found at: " + file.getAbsolutePath());
            log.severe("Usage: java -jar NetBeansPublicPackages.jar [path-to-definition-xml-file]");
            NetBeansPublicPackages.example(log);
            log.info("---[[ END ]]---");
            System.exit(1);
            return;
        }
        try {
            publicPackages = new NetBeansPublicPackages(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.severe("Usage: java -jar RewriteFiles.jar [path-to-definition-xml-file]");
            NetBeansPublicPackages.example(log);
            log.info("---[[ END ]]---");
            return;
        }
        publicPackages.setLog(log);
        log.info("Definition file loaded.");
        boolean result = publicPackages.rewrite();
        if (result) {
            log.info("System.exit(0)");
        } else {
            log.warning("Failure! System.exit(1)!");
            System.exit(1);
        }
        log.info("---[[ END ]]---");
        if (result) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }
}

