/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.netbeans.publicpkgs;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import cz.cuni.amis.netbeans.publicpkgs.MyDirectoryWalker;
import cz.cuni.amis.utils.Const;
import cz.cuni.amis.utils.FilePath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.filefilter.WildcardFileFilter;

@XStreamAlias(value="includeDir")
public class IncludeDir {
    @XStreamAlias(value="dir")
    @XStreamAsAttribute
    private File dir;
    @XStreamAlias(value="subdirs")
    @XStreamAsAttribute
    private Boolean subdirs = true;
    @XStreamImplicit(itemFieldName="excludeDir")
    private List<String> excludeDirs = new ArrayList<String>();
    @XStreamOmitField
    private MyDirectoryWalker directoryWalker;
    @XStreamOmitField
    private transient WildcardFileFilter includeFileFilter;
    @XStreamOmitField
    private transient WildcardFileFilter excludeFileFilter;

    public IncludeDir() {
    }

    public IncludeDir(IncludeDir orig, IncludeDir globals) {
        this();
        this.dir = orig.dir;
        if (this.dir == null) {
            this.dir = globals.dir;
        }
        this.subdirs = orig.subdirs;
        if (this.subdirs == null) {
            this.subdirs = globals.subdirs;
        }
        if (orig.excludeDirs != null) {
            for (String path : orig.excludeDirs) {
                this.excludeDirs.add(path);
            }
        }
        if (globals.excludeDirs != null) {
            for (String path : globals.excludeDirs) {
                this.excludeDirs.add(path);
            }
        }
    }

    private IncludeDir readResolve() {
        if (this.subdirs == null) {
            this.subdirs = true;
        }
        if (this.excludeDirs == null) {
            this.excludeDirs = new ArrayList<String>(0);
        }
        return this;
    }

    public File getDir() {
        return this.dir;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public Boolean getSubdirs() {
        return this.subdirs;
    }

    public void setSubdirs(Boolean subdirs) {
        this.subdirs = subdirs;
    }

    public List<String> getExcludeDirs() {
        return this.excludeDirs;
    }

    public void setExcludeDirs(List<String> excludeDirs) {
        this.excludeDirs = excludeDirs;
    }

    public MyDirectoryWalker getDirectoryWalker() {
        if (this.directoryWalker == null) {
            this.initDirectoryWalker();
        }
        return this.directoryWalker;
    }

    private void initDirectoryWalker() {
        this.directoryWalker = new MyDirectoryWalker(){

            protected boolean handleDirectory(File directory, int depth, Collection results) throws IOException {
                if (IncludeDir.this.acceptDir(directory)) {
                    results.add(directory);
                    return true;
                }
                return false;
            }

            protected void handleFile(File file, int depth, Collection results) throws IOException {
                if (IncludeDir.this.acceptFile(file)) {
                    results.add(file);
                }
            }
        };
    }

    private boolean acceptDir(File pathToDir) {
        String absolute = FilePath.makeUniform((String)pathToDir.getAbsolutePath());
        for (String exclude : this.excludeDirs) {
            if (!absolute.endsWith(exclude)) continue;
            return false;
        }
        return true;
    }

    private boolean acceptFile(File pathToFile) {
        return false;
    }

    public void initialize() {
        if (this.subdirs == null) {
            this.subdirs = true;
        }
        if (this.excludeDirs == null) {
            this.excludeDirs = new ArrayList<String>(0);
        }
        int i = 0;
        while (i < this.excludeDirs.size()) {
            if (this.excludeDirs.get(i) == null) {
                this.excludeDirs.remove(i);
                continue;
            }
            this.excludeDirs.set(i, FilePath.makeUniform((String)this.excludeDirs.get(i)));
            if (this.excludeDirs.get(i) == null) {
                this.excludeDirs.remove(i);
                continue;
            }
            ++i;
        }
    }

    public String toString() {
        return this.toString("IncludeDir", "");
    }

    public String toString(String name, String prefix) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        sb.append(String.valueOf(prefix) + name + "[");
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "  dir           = " + this.dir + (this.dir != null ? " --> " + this.dir.getAbsolutePath() : ""));
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "  subdirs       = " + this.subdirs);
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "  excludeDirs   = ");
        if (this.excludeDirs == null) {
            sb.append("null");
        } else {
            for (String file : this.excludeDirs) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(file);
            }
        }
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "]");
        return sb.toString();
    }
}

