/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.dash;

import com.sun.jdi.AbsentInformationException;
import cz.cuni.amis.dash.ServerManager;
import cz.cuni.amis.pogamut.sposh.dbg.engine.AbstractDebugEngine;
import cz.cuni.amis.pogamut.sposh.dbg.engine.EngineThread;
import cz.cuni.amis.pogamut.sposh.dbg.engine.EvaluationListener;
import cz.cuni.amis.pogamut.sposh.dbg.engine.IDebugEngineListener;
import cz.cuni.amis.pogamut.sposh.dbg.exceptions.UnexpectedMessageException;
import cz.cuni.amis.pogamut.sposh.dbg.lap.LapBreakpoint;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshParser;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.engine.EngineLog;
import cz.cuni.amis.pogamut.sposh.engine.PoshEngine;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.openide.util.Exceptions;

public final class YaposhEngine
extends AbstractDebugEngine {
    private static final String[] ENGINE_CLASS_FILTER = new String[]{PoshEngine.class.getName()};
    private static final String EVALUATION_METHOD_NAME = "evaluatePlan";
    private static final String EVALUATION_METHOD_SIGNATURE = "(Lcz/cuni/amis/pogamut/sposh/executor/IWorkExecutor;)Lcz/cuni/amis/pogamut/sposh/engine/PoshEngine$EvaluationResultInfo;";
    private static final String EVALUATION_EXIT_METHOD_NAME = "evaluatePlanExit";
    private static final String EVALUATION_EXIT_METHOD_SIGNATURE = "()V";
    private static final String[] ENGINE_LOG_CLASS_FILTER = new String[]{EngineLog.class.getName()};
    private static final String PATH_REACHED_EXIT_METHOD_NAME = "pathReachedExit";
    private static final String PATH_REACHED_EXIT_METHOD_SIGNATURE = "()V";
    private static final String BREAKPOINT_GROUP_NAME = "dash";
    private final EngineThread engineThread;
    private MethodBreakpoint evaluationEntryBreakpoint;
    private JPDABreakpointListener getPlanListener;
    private JPDABreakpointListener notifyEvaluationReached;
    private MethodBreakpoint pathReachedBreakpoint;
    private JPDABreakpointListener pathReachedListener;
    private MethodBreakpoint evaluationExitBreakpoint;
    private JPDABreakpointListener resumeServerListener;
    private JPDABreakpointListener notifyEvaluationFinished;
    private DebuggerManagerListener disconnectListener;
    private ServerManager serverManager;
    private static final Logger log = Logger.getLogger("YaposhEngine");
    private final Set<LapBreakpoint> breakpoints = new HashSet<LapBreakpoint>();
    private PoshPlan plan;
    private final InetSocketAddress serverAddress = new InetSocketAddress("localhost", 3001);

    public YaposhEngine(EngineThread engineThread) {
        this.engineThread = engineThread;
    }

    @Override
    public void initialize() {
        log.info("Connect to the server");
        this.serverManager = new ServerManager();
        this.serverManager.connect();
        log.info("Adding breakpoint at evaluation entry");
        this.evaluationEntryBreakpoint = this.createEvaluationEntryBreakpoint(BREAKPOINT_GROUP_NAME);
        this.getPlanListener = new GetPlanListener();
        this.evaluationEntryBreakpoint.addJPDABreakpointListener(this.getPlanListener);
        this.notifyEvaluationReached = new NotifyEvaluationReached();
        this.evaluationEntryBreakpoint.addJPDABreakpointListener(this.notifyEvaluationReached);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.evaluationEntryBreakpoint);
        log.info("Adding breakpoint at path reached method");
        this.pathReachedListener = new PathReachedListener();
        this.pathReachedBreakpoint = this.createPathReachedExitBreakpoint(BREAKPOINT_GROUP_NAME);
        this.pathReachedBreakpoint.addJPDABreakpointListener(this.pathReachedListener);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.pathReachedBreakpoint);
        log.info("Adding breakpoint at evaluation exit");
        this.evaluationExitBreakpoint = this.createEvaluationExitBreakpoint(BREAKPOINT_GROUP_NAME);
        this.resumeServerListener = new ResumeServerListener();
        this.evaluationExitBreakpoint.addJPDABreakpointListener(this.resumeServerListener);
        this.notifyEvaluationFinished = new NotifyEvaluationFinished();
        this.evaluationExitBreakpoint.addJPDABreakpointListener(this.notifyEvaluationFinished);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.evaluationExitBreakpoint);
        log.info("Adding cleanup listener");
        this.disconnectListener = new DisconnectListener();
        DebuggerManager.getDebuggerManager().addDebuggerListener(this.disconnectListener);
        this.notifyConnected();
    }

    @Override
    public void disconnect(String reason, boolean error) {
        log.info("Disconnect from the server");
        this.serverManager.disconnect();
        log.info("Removing breakpoint at evaluation entry");
        this.evaluationEntryBreakpoint.removeJPDABreakpointListener(this.getPlanListener);
        this.evaluationEntryBreakpoint.removeJPDABreakpointListener(this.notifyEvaluationReached);
        DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.evaluationEntryBreakpoint);
        log.info("Removing breakpoint at processing path method");
        this.pathReachedBreakpoint.removeJPDABreakpointListener(this.pathReachedListener);
        DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.pathReachedBreakpoint);
        log.info("Removing breakpoint at evaluation exit");
        this.evaluationExitBreakpoint.removeJPDABreakpointListener(this.resumeServerListener);
        this.evaluationExitBreakpoint.removeJPDABreakpointListener(this.notifyEvaluationFinished);
        DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.evaluationExitBreakpoint);
        log.info("Removing cleanup listener");
        DebuggerManager.getDebuggerManager().removeDebuggerListener(this.disconnectListener);
        this.notifyDisconnected(reason, error);
    }

    private MethodBreakpoint createPathReachedExitBreakpoint(String groupName) {
        MethodBreakpoint bp = MethodBreakpoint.create();
        bp.setClassFilters(ENGINE_LOG_CLASS_FILTER);
        bp.setMethodName(PATH_REACHED_EXIT_METHOD_NAME);
        bp.setMethodSignature("()V");
        bp.setGroupName(groupName);
        bp.setSuspend(0);
        bp.setBreakpointType(1);
        return bp;
    }

    private MethodBreakpoint createEvaluationEntryBreakpoint(String groupName) {
        MethodBreakpoint bp = MethodBreakpoint.create();
        bp.setClassFilters(ENGINE_CLASS_FILTER);
        bp.setMethodName(EVALUATION_METHOD_NAME);
        bp.setMethodSignature(EVALUATION_METHOD_SIGNATURE);
        bp.setGroupName(groupName);
        bp.setSuspend(0);
        bp.setBreakpointType(1);
        return bp;
    }

    private MethodBreakpoint createEvaluationExitBreakpoint(String groupName) {
        MethodBreakpoint bp = MethodBreakpoint.create();
        bp.setClassFilters(ENGINE_CLASS_FILTER);
        bp.setMethodName(EVALUATION_EXIT_METHOD_NAME);
        bp.setMethodSignature("()V");
        bp.setGroupName(groupName);
        bp.setSuspend(0);
        bp.setBreakpointType(1);
        return bp;
    }

    @Override
    public boolean addBreakpoint(LapPath path, boolean single) {
        assert (SwingUtilities.isEventDispatchThread());
        this.removeBreakpoint(path);
        LapBreakpoint breakpoint = new LapBreakpoint(path, single);
        boolean ret = this.breakpoints.add(breakpoint);
        for (IDebugEngineListener listener : this.getListeners()) {
            listener.breakpointAdded(breakpoint);
        }
        return ret;
    }

    private LapBreakpoint findBreakpoint(LapPath searchedPath) {
        for (LapBreakpoint bp : this.breakpoints) {
            if (!bp.getPath().equals((Object)searchedPath)) continue;
            return bp;
        }
        return null;
    }

    @Override
    public boolean removeBreakpoint(LapPath path) {
        assert (SwingUtilities.isEventDispatchThread());
        LapBreakpoint foundBp = this.findBreakpoint(path);
        if (foundBp != null) {
            this.breakpoints.remove(foundBp);
            for (IDebugEngineListener listener : this.getListeners()) {
                listener.breakpointRemoved(foundBp);
            }
            return true;
        }
        return false;
    }

    private void removeBreakpointInEDT(final LapPath path) throws InterruptedException, InvocationTargetException {
        Runnable removeBreakpoint = new Runnable(){

            @Override
            public void run() {
                YaposhEngine.this.removeBreakpoint(path);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            removeBreakpoint.run();
        } else {
            SwingUtilities.invokeAndWait(removeBreakpoint);
        }
    }

    private void disconnectInEDT(final String disconnectMsg, final boolean error) {
        Runnable disconnectRunnable = new Runnable(){

            @Override
            public void run() {
                YaposhEngine.this.disconnect(disconnectMsg, error);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            disconnectRunnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(disconnectRunnable);
            }
            catch (Exception ex) {
                throw new FubarException((Throwable)ex);
            }
        }
    }

    private void notifyPathReachedInEDT(final LapPath path) throws InterruptedException, InvocationTargetException {
        log.log(Level.INFO, "Notify pathReached in EDT {0}", Thread.currentThread());
        Runnable notifyPathReachedRunnable = new Runnable(){

            @Override
            public void run() {
                YaposhEngine.this.notifyPathReached(path);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            notifyPathReachedRunnable.run();
        } else {
            SwingUtilities.invokeAndWait(notifyPathReachedRunnable);
        }
    }

    private void notifyEvaluationReachedInEDT() throws InterruptedException, InvocationTargetException {
        log.log(Level.INFO, "Notify evaluationReached in EDT {0}", Thread.currentThread());
        Runnable notifyEvaluationReachedRunnable = new Runnable(){

            @Override
            public void run() {
                YaposhEngine.this.notifyEvaluationReached();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            notifyEvaluationReachedRunnable.run();
        } else {
            SwingUtilities.invokeAndWait(notifyEvaluationReachedRunnable);
        }
    }

    private void notifyEvaluationFinishedInEDT() throws InterruptedException, InvocationTargetException {
        log.log(Level.INFO, "Notify evaluationFinished in EDT {0}", Thread.currentThread());
        Runnable notifyEvaluationFinishedRunnable = new Runnable(){

            @Override
            public void run() {
                YaposhEngine.this.notifyEvaluationFinished();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            notifyEvaluationFinishedRunnable.run();
        } else {
            SwingUtilities.invokeAndWait(notifyEvaluationFinishedRunnable);
        }
    }

    private class DisconnectListener
    extends DebuggerManagerAdapter {
        private DisconnectListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionRemoved(Session session) {
            if (this.isDebuggerInSession(session, YaposhEngine.this.engineThread.getDebugger())) {
                boolean error = false;
                String disconnectMessage = "The session has been terminated.";
                try {
                    ServerManager.resume(YaposhEngine.this, YaposhEngine.this.serverAddress);
                    ServerManager.clear(YaposhEngine.this);
                }
                catch (IOException ex) {
                    error = true;
                    disconnectMessage = "Unable to resume the server " + YaposhEngine.this.serverAddress.toString();
                }
                finally {
                    YaposhEngine.this.disconnectInEDT(disconnectMessage, error);
                }
            }
        }

        private boolean isDebuggerInSession(Session session, JPDADebugger debugger) {
            if (session.getCurrentEngine().lookup(null, JPDADebugger.class).contains(debugger)) {
                return true;
            }
            for (String language : session.getSupportedLanguages()) {
                DebuggerEngine engine = session.getEngineForLanguage(language);
                List engineDebuggers = engine.lookup(null, JPDADebugger.class);
                if (!engineDebuggers.contains(debugger)) continue;
                return true;
            }
            return false;
        }
    }

    private class ResumeServerListener
    implements JPDABreakpointListener {
        private ResumeServerListener() {
        }

        public void breakpointReached(JPDABreakpointEvent jpdabe) {
            try {
                ServerManager.resume(YaposhEngine.this, YaposhEngine.this.serverAddress);
            }
            catch (IOException ex) {
                String disconnectMessage = MessageFormat.format("Unable to resume the server {0}", YaposhEngine.this.serverAddress.toString());
                YaposhEngine.this.disconnectInEDT(disconnectMessage, true);
            }
        }
    }

    private class GetPlanListener
    extends EvaluationListener {
        private final String GET_PLAN_METHOD = "getPoshPlan";
        private String planText;

        private GetPlanListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void breakpointReached(JPDABreakpointEvent event) {
            block17: {
                JPDAThread breakpointThread = event.getThread();
                if (!breakpointThread.equals(YaposhEngine.this.engineThread.getThread())) {
                    return;
                }
                if (this.planText != null) {
                    return;
                }
                String errorMsg = null;
                try {
                    this.planText = this.getPlan(event);
                    log.log(Level.INFO, "Plan recieved: {0}", this.planText);
                    YaposhEngine.this.plan = new PoshParser((Reader)new StringReader(this.planText)).parsePlan();
                    this.notifyEnginePlanRecieved();
                }
                catch (AbsentInformationException ex) {
                    errorMsg = "Unable to get the plan from the engine. Engine thread is running or has no callstack.";
                }
                catch (NoSuchMethodException ex) {
                    errorMsg = MessageFormat.format("Unable to get the plan from the engine. No member method String {0}() found.", "getPoshPlan");
                }
                catch (InvalidExpressionException ex) {
                    errorMsg = MessageFormat.format("Unable to get the plan from the engine. {0}", ex.getMessage());
                }
                catch (InterruptedException ex) {
                    errorMsg = "EDT thread was interrupted while notifying listeners about plan.";
                }
                catch (InvocationTargetException ex) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    ex.getCause().printStackTrace(printWriter);
                    printWriter.flush();
                    String stackTrace = stringWriter.toString();
                    errorMsg = MessageFormat.format("While notifying listeners about plan, an exception was thrown: {0}: {1}<br/><pre>{2}</pre>", ex.getCause(), ex.getCause().toString(), stackTrace);
                }
                catch (ParseException ex) {
                    errorMsg = MessageFormat.format("Unable to parse plan: {0}, {1}", this.planText, ex.getMessage());
                }
                finally {
                    if (errorMsg == null) break block17;
                    log.log(Level.SEVERE, errorMsg);
                    YaposhEngine.this.disconnectInEDT(errorMsg, true);
                    return;
                }
            }
        }

        private String getPlan(JPDABreakpointEvent jpdabe) throws AbsentInformationException, NoSuchMethodException, InvalidExpressionException {
            JPDAThread thread = jpdabe.getThread();
            This thisVar = this.getThisVariable(thread);
            return this.callStringMethod(jpdabe.getDebugger(), thisVar, thread, "getPoshPlan");
        }

        private void notifyEnginePlanRecieved() throws InterruptedException, InvocationTargetException {
            final String name = this.getDisplayName(YaposhEngine.this.engineThread.getDebugger(), YaposhEngine.this.engineThread);
            Runnable notifyRunnable = new Runnable(){

                @Override
                public void run() {
                    YaposhEngine.this.notifyPlanRecieved(name, YaposhEngine.this.plan);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                notifyRunnable.run();
            } else {
                SwingUtilities.invokeAndWait(notifyRunnable);
            }
        }
    }

    private class NotifyEvaluationFinished
    extends EvaluationListener {
        private NotifyEvaluationFinished() {
        }

        public void breakpointReached(JPDABreakpointEvent event) {
            JPDAThread breakpointThread = event.getThread();
            if (!breakpointThread.equals(YaposhEngine.this.engineThread.getThread())) {
                return;
            }
            try {
                YaposhEngine.this.notifyEvaluationFinishedInEDT();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private class NotifyEvaluationReached
    extends EvaluationListener {
        private NotifyEvaluationReached() {
        }

        public void breakpointReached(JPDABreakpointEvent event) {
            JPDAThread breakpointThread = event.getThread();
            if (!breakpointThread.equals(YaposhEngine.this.engineThread.getThread())) {
                return;
            }
            try {
                YaposhEngine.this.notifyEvaluationReachedInEDT();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private class PathReachedListener
    extends EvaluationListener {
        private final String GET_REACHED_PATH_METHOD = "getLastReachedPath";

        private PathReachedListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void breakpointReached(JPDABreakpointEvent jpdabe) {
            LapPath path;
            block29: {
                JPDAThread breakpointThread = jpdabe.getThread();
                if (!breakpointThread.equals(YaposhEngine.this.engineThread.getThread())) {
                    return;
                }
                String errorMsg = null;
                String pathString = null;
                path = null;
                try {
                    pathString = this.getPath(jpdabe);
                    path = LapPath.parse((String)pathString);
                    YaposhEngine.this.notifyPathReachedInEDT(path);
                }
                catch (AbsentInformationException ex) {
                    errorMsg = "Unable to get the path from the engine. Engine thread is running or has no callstack.";
                }
                catch (NoSuchMethodException ex) {
                    errorMsg = MessageFormat.format("Unable to get the path from the engine. No member method String {0}() found.", "getLastReachedPath");
                }
                catch (InvalidExpressionException ex) {
                    errorMsg = MessageFormat.format("Unable to get the path from the engine. {0}", ex.getMessage());
                }
                catch (ParseException ex) {
                    errorMsg = MessageFormat.format("Unable to parse recieved path {0}: {1}", pathString, ex.getMessage());
                }
                catch (InterruptedException ex) {
                    errorMsg = MessageFormat.format("EDT thread was interrupted while notifying listeners about new path {0}.", pathString);
                }
                catch (InvocationTargetException ex) {
                    errorMsg = MessageFormat.format("While notifying listeners about plan {0}, an exception was thrown: {1}", pathString, ex.toString());
                }
                finally {
                    if (errorMsg == null) break block29;
                    log.log(Level.SEVERE, errorMsg);
                    YaposhEngine.this.disconnectInEDT(errorMsg, true);
                    return;
                }
            }
            for (LapBreakpoint breakpoint : YaposhEngine.this.breakpoints) {
                MethodBreakpoint javaBreakpoint;
                if (!breakpoint.getPath().equals((Object)path)) continue;
                if (breakpoint.isSingle()) {
                    try {
                        YaposhEngine.this.removeBreakpointInEDT(path);
                    }
                    catch (InterruptedException ex) {
                        YaposhEngine.this.disconnectInEDT("While removing breakpoint, the EDT thread was interrupted.", true);
                        return;
                    }
                    catch (InvocationTargetException ex) {
                        YaposhEngine.this.disconnectInEDT("Exception during breakpoint removal " + ex.getCause(), true);
                        return;
                    }
                }
                String breakpointFQN = breakpoint.getPrimitiveName(YaposhEngine.this.plan);
                DebuggerManager dm = DebuggerManager.getDebuggerManager();
                LapType bpType = breakpoint.getType(YaposhEngine.this.plan);
                if (bpType == LapType.ACTION) {
                    javaBreakpoint = this.createSelfRemoveBreakpoint(breakpointFQN, "run", 1);
                } else if (bpType == LapType.SENSE) {
                    javaBreakpoint = this.createSelfRemoveBreakpoint(breakpointFQN, "query", 1);
                } else {
                    throw new IllegalStateException("Lap breakpoint at path " + breakpoint.getPath() + " is not ACTIOn nor SENSE.");
                }
                boolean isDuplicate = false;
                for (Breakpoint testedBreakpoint : dm.getBreakpoints()) {
                    if (!(testedBreakpoint instanceof MethodBreakpoint)) continue;
                    MethodBreakpoint methodBreakpoint = (MethodBreakpoint)testedBreakpoint;
                    if (!Arrays.equals(javaBreakpoint.getClassFilters(), methodBreakpoint.getClassFilters()) || !javaBreakpoint.getMethodName().equals(methodBreakpoint.getMethodName()) || !javaBreakpoint.getMethodSignature().equals(methodBreakpoint.getMethodSignature())) continue;
                    isDuplicate = true;
                }
                try {
                    ServerManager.pause(YaposhEngine.this, YaposhEngine.this.serverAddress);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (UnexpectedMessageException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (isDuplicate) continue;
                dm.addBreakpoint((Breakpoint)javaBreakpoint);
            }
        }

        private String getPath(JPDABreakpointEvent jpdabe) throws AbsentInformationException, NoSuchMethodException, InvalidExpressionException {
            JPDAThread thread = jpdabe.getThread();
            This thisVar = this.getThisVariable(thread);
            String stringPath = this.callStringMethod(jpdabe.getDebugger(), thisVar, thread, "getLastReachedPath");
            return stringPath;
        }
    }
}

