/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.dbg.engine;

import cz.cuni.amis.pogamut.sposh.dbg.engine.IDebugEngine;
import cz.cuni.amis.pogamut.sposh.dbg.engine.IDebugEngineListener;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;

public abstract class AbstractDebugEngine
implements IDebugEngine {
    private final Set<IDebugEngineListener> listeners = new HashSet<IDebugEngineListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean addListener(IDebugEngineListener listener) {
        assert (listener != null);
        Set<IDebugEngineListener> set = this.listeners;
        synchronized (set) {
            return this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeListener(IDebugEngineListener listener) {
        assert (listener != null);
        Set<IDebugEngineListener> set = this.listeners;
        synchronized (set) {
            return this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IDebugEngineListener[] getListeners() {
        Set<IDebugEngineListener> set = this.listeners;
        synchronized (set) {
            return this.listeners.toArray(new IDebugEngineListener[this.listeners.size()]);
        }
    }

    protected final void notifyConnected() {
        assert (SwingUtilities.isEventDispatchThread());
        for (IDebugEngineListener listener : this.getListeners()) {
            listener.connected();
        }
    }

    protected final void notifyPlanRecieved(String name, PoshPlan plan) {
        assert (SwingUtilities.isEventDispatchThread());
        for (IDebugEngineListener listener : this.getListeners()) {
            listener.planRecieved(name, plan);
        }
    }

    protected final void notifyEvaluationReached() {
        assert (SwingUtilities.isEventDispatchThread());
        for (IDebugEngineListener listener : this.getListeners()) {
            listener.evaluationReached();
        }
    }

    protected final void notifyEvaluationFinished() {
        assert (SwingUtilities.isEventDispatchThread());
        for (IDebugEngineListener listener : this.getListeners()) {
            listener.evaluationFinished();
        }
    }

    protected final void notifyPathReached(LapPath path) {
        assert (SwingUtilities.isEventDispatchThread());
        for (IDebugEngineListener listener : this.getListeners()) {
            listener.pathReached(path);
        }
    }

    protected final void notifyDisconnected(String message, boolean error) {
        assert (SwingUtilities.isEventDispatchThread());
        for (IDebugEngineListener listener : this.getListeners()) {
            listener.disconnected(message, error);
        }
    }
}

