/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine.fonts;

import cz.cuni.amis.clear2d.engine.textures.Subtexture;
import cz.cuni.amis.clear2d.engine.textures.Texture;
import cz.cuni.amis.clear2d.utils.ColorMulti;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class FontAtlas
extends Texture {
    private int glyphsX;
    private int glyphsY;
    private int glyphWidth;
    private int glyphHeight;
    private Map<Integer, Subtexture> glyphs;

    protected void init(BufferedImage image, int glyphsX, int glyphsY, String text, Color colorMulti) {
        if (colorMulti != null) {
            image = ColorMulti.multi(image, colorMulti);
        }
        this.init(image, glyphsX, glyphsY, text);
    }

    protected void init(BufferedImage image, int glyphsX, int glyphsY, String text) {
        this.setImage(image);
        this.glyphsX = glyphsX;
        this.glyphsY = glyphsY;
        if (image.getWidth() % glyphsX != 0) {
            throw new RuntimeException("Font atlas image width not divisible with glyphsX. Font atlas image dimensions are " + image.getWidth() + "x" + image.getHeight() + "px, cannot cut out " + glyphsX + "x" + glyphsY + " glyphs.");
        }
        if (image.getHeight() % glyphsY != 0) {
            throw new RuntimeException("Font atlas image width not divisible with glyphsY. Font atlas image dimensions are " + image.getWidth() + "x" + image.getHeight() + "px, cannot cut out " + glyphsX + "x" + glyphsY + " glyphs.");
        }
        this.glyphWidth = image.getWidth() / glyphsX;
        this.glyphHeight = image.getHeight() / glyphsY;
        int charNumber = 0;
        this.glyphs = new HashMap<Integer, Subtexture>();
        int y = 0;
        while (y < glyphsY) {
            if (charNumber >= text.length()) break;
            int x = 0;
            while (x < glyphsX) {
                if (charNumber >= text.length()) break;
                Subtexture glyphTex = new Subtexture("" + text.charAt(charNumber), this, x * this.glyphWidth, y * this.glyphHeight, x * this.glyphWidth + this.glyphWidth, y * this.glyphHeight + this.glyphHeight);
                char glyphOrd = text.charAt(charNumber);
                this.glyphs.put(Integer.valueOf(glyphOrd), glyphTex);
                ++charNumber;
                ++x;
            }
            ++y;
        }
    }

    public int getGlyphsX() {
        return this.glyphsX;
    }

    public int getGlyphsY() {
        return this.glyphsY;
    }

    public int getGlyphWidth() {
        return this.glyphWidth;
    }

    public int getGlyphHeight() {
        return this.glyphHeight;
    }

    public Subtexture getGlyph(String c) {
        return this.glyphs.get(c.charAt(0));
    }

    public Subtexture getGlyph(char c) {
        return this.glyphs.get(c);
    }
}

